/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.eclipse.jdt.jdk8.core.dom.rewrite;

import io.spring.javaformat.eclipse.jdt.jdk8.core.ICompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.ITypeRoot;
import io.spring.javaformat.eclipse.jdt.jdk8.core.JavaModelException;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.AST;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ASTNode;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildListPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.ChildPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.CompilationUnit;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.SimplePropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.StructuralPropertyDescriptor;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.rewrite.ListRewrite;
import io.spring.javaformat.eclipse.jdt.jdk8.core.dom.rewrite.TargetSourceRangeComputer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.compiler.parser.RecoveryScannerData;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom.rewrite.ASTRewriteAnalyzer;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom.rewrite.LineInformation;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom.rewrite.NodeInfoStore;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom.rewrite.NodeRewriteEvent;
import io.spring.javaformat.eclipse.jdt.jdk8.internal.core.dom.rewrite.RewriteEventStore;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ASTRewrite {
    private final AST ast;
    private final RewriteEventStore eventStore;
    private final NodeInfoStore nodeStore;
    private TargetSourceRangeComputer targetSourceRangeComputer = null;
    private Object property1 = null;
    private Object property2 = null;

    public static ASTRewrite create(AST ast) {
        return new ASTRewrite(ast);
    }

    protected ASTRewrite(AST ast) {
        this.ast = ast;
        this.eventStore = new RewriteEventStore();
        this.nodeStore = new NodeInfoStore(ast);
    }

    public final AST getAST() {
        return this.ast;
    }

    protected final RewriteEventStore getRewriteEventStore() {
        return this.eventStore;
    }

    protected final NodeInfoStore getNodeStore() {
        return this.nodeStore;
    }

    public TextEdit rewriteAST() throws JavaModelException, IllegalArgumentException {
        ASTNode rootNode = this.getRootNode();
        if (rootNode == null) {
            return new MultiTextEdit();
        }
        ASTNode root = rootNode.getRoot();
        if (!(root instanceof CompilationUnit)) {
            throw new IllegalArgumentException("This API can only be used if the AST is created from a compilation unit or class file");
        }
        CompilationUnit astRoot = (CompilationUnit)root;
        ITypeRoot typeRoot = astRoot.getTypeRoot();
        if (typeRoot == null || typeRoot.getBuffer() == null) {
            throw new IllegalArgumentException("This API can only be used if the AST is created from a compilation unit or class file");
        }
        char[] content = typeRoot.getBuffer().getCharacters();
        LineInformation lineInfo = LineInformation.create(astRoot);
        String lineDelim = typeRoot.findRecommendedLineSeparator();
        Map<String, String> options = typeRoot instanceof ICompilationUnit ? ((ICompilationUnit)typeRoot).getOptions(true) : typeRoot.getJavaProject().getOptions(true);
        return this.internalRewriteAST(content, lineInfo, lineDelim, astRoot.getCommentList(), options, rootNode, (RecoveryScannerData)astRoot.getStatementsRecoveryData());
    }

    private TextEdit internalRewriteAST(char[] content, LineInformation lineInfo, String lineDelim, List commentNodes, Map options, ASTNode rootNode, RecoveryScannerData recoveryScannerData) {
        MultiTextEdit result = new MultiTextEdit();
        TargetSourceRangeComputer sourceRangeComputer = this.getExtendedSourceRangeComputer();
        this.eventStore.prepareMovedNodes(sourceRangeComputer);
        ASTRewriteAnalyzer visitor = new ASTRewriteAnalyzer(content, lineInfo, lineDelim, (TextEdit)result, this.eventStore, this.nodeStore, commentNodes, options, sourceRangeComputer, recoveryScannerData);
        rootNode.accept(visitor);
        this.eventStore.revertMovedNodes();
        return result;
    }

    private ASTNode getRootNode() {
        ASTNode node = null;
        int start = -1;
        int end = -1;
        Iterator iter = this.getRewriteEventStore().getChangeRootIterator();
        while (iter.hasNext()) {
            ASTNode curr = (ASTNode)iter.next();
            if (RewriteEventStore.isNewNode(curr)) continue;
            int currStart = curr.getStartPosition();
            int currEnd = currStart + curr.getLength();
            if (node == null || currStart < start && currEnd > end) {
                start = currStart;
                end = currEnd;
                node = curr;
                continue;
            }
            if (currStart < start) {
                start = currStart;
                continue;
            }
            if (currEnd <= end) continue;
            end = currEnd;
        }
        if (node != null) {
            int currStart = node.getStartPosition();
            int currEnd = currStart + node.getLength();
            while (start < currStart || end > currEnd) {
                node = node.getParent();
                currStart = node.getStartPosition();
                currEnd = currStart + node.getLength();
            }
            ASTNode parent = node.getParent();
            while (parent != null && parent.getStartPosition() == node.getStartPosition() && parent.getLength() == node.getLength()) {
                node = parent;
                parent = node.getParent();
            }
        }
        return node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void remove(ASTNode node, TextEditGroup editGroup) {
        ASTNode parent;
        StructuralPropertyDescriptor property;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (RewriteEventStore.isNewNode(node)) {
            RewriteEventStore.PropertyLocation location = this.eventStore.getPropertyLocation(node, 1);
            if (location == null) throw new IllegalArgumentException("Node is not part of the rewriter's AST");
            property = location.getProperty();
            parent = location.getParent();
        } else {
            property = node.getLocationInParent();
            parent = node.getParent();
        }
        if (property.isChildListProperty()) {
            this.getListRewrite(parent, (ChildListPropertyDescriptor)property).remove(node, editGroup);
            return;
        } else {
            this.set(parent, property, null, editGroup);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void replace(ASTNode node, ASTNode replacement, TextEditGroup editGroup) {
        ASTNode parent;
        StructuralPropertyDescriptor property;
        if (node == null) {
            throw new IllegalArgumentException();
        }
        if (RewriteEventStore.isNewNode(node)) {
            RewriteEventStore.PropertyLocation location = this.eventStore.getPropertyLocation(node, 1);
            if (location == null) throw new IllegalArgumentException("Node is not part of the rewriter's AST");
            property = location.getProperty();
            parent = location.getParent();
        } else {
            property = node.getLocationInParent();
            parent = node.getParent();
        }
        if (property.isChildListProperty()) {
            this.getListRewrite(parent, (ChildListPropertyDescriptor)property).replace(node, replacement, editGroup);
            return;
        } else {
            this.set(parent, property, replacement, editGroup);
        }
    }

    public final void set(ASTNode node, StructuralPropertyDescriptor property, Object value, TextEditGroup editGroup) {
        if (node == null || property == null) {
            throw new IllegalArgumentException();
        }
        this.validateIsCorrectAST(node);
        this.validatePropertyType(property, value);
        this.validateIsPropertyOfNode(property, node);
        NodeRewriteEvent nodeEvent = this.eventStore.getNodeEvent(node, property, true);
        nodeEvent.setNewValue(value);
        if (editGroup != null) {
            this.eventStore.setEventEditGroup(nodeEvent, editGroup);
        }
    }

    public final ListRewrite getListRewrite(ASTNode node, ChildListPropertyDescriptor property) {
        if (node == null || property == null) {
            throw new IllegalArgumentException();
        }
        this.validateIsCorrectAST(node);
        this.validateIsListProperty(property);
        this.validateIsPropertyOfNode(property, node);
        return new ListRewrite(this, node, property);
    }

    private void validateIsCorrectAST(ASTNode node) {
        if (node.getAST() != this.getAST()) {
            throw new IllegalArgumentException("Node is not inside the AST");
        }
    }

    private void validateIsListProperty(StructuralPropertyDescriptor property) {
        if (!property.isChildListProperty()) {
            String message = String.valueOf(property.getId()) + " is not a list property";
            throw new IllegalArgumentException(message);
        }
    }

    private void validateIsPropertyOfNode(StructuralPropertyDescriptor property, ASTNode node) {
        if (!property.getNodeClass().isInstance(node)) {
            String message = String.valueOf(property.getId()) + " is not a property of type " + node.getClass().getName();
            throw new IllegalArgumentException(message);
        }
    }

    private void validatePropertyType(StructuralPropertyDescriptor prop, Object value) {
        if (prop.isChildListProperty()) {
            String message = "Can not modify a list property, use getListRewrite()";
            throw new IllegalArgumentException(message);
        }
        if (!RewriteEventStore.DEBUG) {
            return;
        }
        if (value == null) {
            if (prop.isSimpleProperty() && ((SimplePropertyDescriptor)prop).isMandatory() || prop.isChildProperty() && ((ChildPropertyDescriptor)prop).isMandatory()) {
                String message = "Can not remove property " + prop.getId();
                throw new IllegalArgumentException(message);
            }
        } else {
            Class valueType;
            StructuralPropertyDescriptor p;
            if (prop.isSimpleProperty()) {
                p = (SimplePropertyDescriptor)prop;
                valueType = ((SimplePropertyDescriptor)p).getValueType();
                if (valueType == Integer.TYPE) {
                    valueType = Integer.class;
                } else if (valueType == Boolean.TYPE) {
                    valueType = Boolean.class;
                }
            } else {
                p = (ChildPropertyDescriptor)prop;
                valueType = ((ChildPropertyDescriptor)p).getChildType();
            }
            if (!valueType.isAssignableFrom(value.getClass())) {
                String message = String.valueOf(value.getClass().getName()) + " is not a valid type for " + prop.getNodeClass().getName() + " property '" + prop.getId() + '\'';
                throw new IllegalArgumentException(message);
            }
        }
    }

    public final ASTNode createStringPlaceholder(String code, int nodeType) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        ASTNode placeholder = this.getNodeStore().newPlaceholderNode(nodeType);
        if (placeholder == null) {
            throw new IllegalArgumentException("String placeholder is not supported for type" + nodeType);
        }
        this.getNodeStore().markAsStringPlaceholder(placeholder, code);
        return placeholder;
    }

    public final TargetSourceRangeComputer getExtendedSourceRangeComputer() {
        if (this.targetSourceRangeComputer == null) {
            this.targetSourceRangeComputer = new TargetSourceRangeComputer();
        }
        return this.targetSourceRangeComputer;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Events:\n");
        if (this.eventStore != null) {
            buf.append(this.eventStore.toString());
        }
        return buf.toString();
    }
}

