/*
 * Decompiled with CFR 0.152.
 */
package io.spring.javaformat.formatter;

import java.util.regex.Pattern;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public abstract class Edit {
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile(" +$", 8);
    private final String originalContent;
    private final TextEdit textEdit;

    protected Edit(String originalContent, TextEdit textEdit) {
        this.originalContent = originalContent;
        this.textEdit = textEdit;
    }

    public boolean hasEdits() {
        return this.textEdit.hasChildren() || this.textEdit.getLength() > 0;
    }

    public String getFormattedContent() throws Exception {
        Document document = new Document(this.originalContent);
        this.textEdit.apply((IDocument)document);
        String formattedContent = document.get();
        return this.trimTrailingWhitespace(formattedContent);
    }

    private String trimTrailingWhitespace(String content) {
        return TRAILING_WHITESPACE.matcher(content).replaceAll("");
    }
}

