/*
 * Decompiled with CFR 0.152.
 */
package io.seata.config.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.Watch;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.kv.TxnResponse;
import io.etcd.jetcd.op.Cmp;
import io.etcd.jetcd.op.CmpTarget;
import io.etcd.jetcd.op.Op;
import io.etcd.jetcd.options.PutOption;
import io.etcd.jetcd.watch.WatchEvent;
import io.etcd.jetcd.watch.WatchResponse;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ConcurrentSet;
import io.seata.common.exception.ShouldNeverHappenException;
import io.seata.common.thread.NamedThreadFactory;
import io.seata.common.util.CollectionUtils;
import io.seata.common.util.StringUtils;
import io.seata.config.AbstractConfiguration;
import io.seata.config.ConfigFuture;
import io.seata.config.Configuration;
import io.seata.config.ConfigurationChangeEvent;
import io.seata.config.ConfigurationChangeListener;
import io.seata.config.ConfigurationFactory;
import io.seata.config.processor.ConfigProcessor;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdConfiguration
extends AbstractConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdConfiguration.class);
    private static volatile EtcdConfiguration instance;
    private static volatile Client client;
    private static final Configuration FILE_CONFIG;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String ETCD_CONFIG_KEY = "key";
    private static final String CONFIG_TYPE = "etcd3";
    private static final String DEFAULT_ETCD_CONFIG_KEY_VALUE = "seata.properties";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.etcd3.";
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ExecutorService etcdConfigExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("etcd-config-executor", 1));
    private static final ConcurrentMap<String, Set<ConfigurationChangeListener>> CONFIG_LISTENERS_MAP;
    private static volatile Properties seataConfig;
    private static final long VERSION_NOT_EXIST = 0L;

    private EtcdConfiguration() {
        EtcdConfiguration.initSeataConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EtcdConfiguration getInstance() {
        if (instance != null) return instance;
        Class<EtcdConfiguration> clazz = EtcdConfiguration.class;
        synchronized (EtcdConfiguration.class) {
            if (instance != null) return instance;
            instance = new EtcdConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = seataConfig.getProperty(dataId);
        if (value != null) {
            return value;
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
        this.etcdConfigExecutor.execute(() -> EtcdConfiguration.complete(EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (String)configFuture.get();
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        if (!seataConfig.isEmpty()) {
            seataConfig.setProperty(dataId, content);
            String etcdConfigKey = EtcdConfiguration.getEtcdConfigKey();
            String seataConfigStr = EtcdConfiguration.getSeataConfigStr();
            ConfigFuture configFuture = new ConfigFuture(etcdConfigKey, seataConfigStr, ConfigFuture.ConfigOperation.PUT, timeoutMills);
            this.etcdConfigExecutor.execute(() -> EtcdConfiguration.complete(EtcdConfiguration.getClient().getKVClient().put(ByteSequence.from((String)etcdConfigKey, (Charset)CharsetUtil.UTF_8), ByteSequence.from((String)seataConfigStr, (Charset)CharsetUtil.UTF_8)), configFuture));
            return (Boolean)configFuture.get();
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        this.etcdConfigExecutor.execute(() -> EtcdConfiguration.complete(EtcdConfiguration.getClient().getKVClient().put(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), ByteSequence.from((String)content, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (Boolean)configFuture.get();
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        if (!seataConfig.isEmpty()) {
            if (seataConfig.contains(dataId)) {
                return true;
            }
            return this.putConfig(dataId, content, timeoutMills);
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        this.etcdConfigExecutor.execute(() -> EtcdConfiguration.complete(client.getKVClient().txn().If(new Cmp[]{new Cmp(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), Cmp.Op.EQUAL, (CmpTarget)CmpTarget.version((long)0L))}).Then(new Op[]{Op.put((ByteSequence)ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8), (ByteSequence)ByteSequence.from((String)content, (Charset)CharsetUtil.UTF_8), (PutOption)PutOption.DEFAULT)}).commit(), configFuture));
        return (Boolean)configFuture.get();
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        if (!seataConfig.isEmpty()) {
            seataConfig.remove(dataId);
            String etcdConfigKey = EtcdConfiguration.getEtcdConfigKey();
            String seataConfigStr = EtcdConfiguration.getSeataConfigStr();
            ConfigFuture configFuture = new ConfigFuture(etcdConfigKey, seataConfigStr, ConfigFuture.ConfigOperation.PUT, timeoutMills);
            this.etcdConfigExecutor.execute(() -> EtcdConfiguration.complete(EtcdConfiguration.getClient().getKVClient().put(ByteSequence.from((String)etcdConfigKey, (Charset)CharsetUtil.UTF_8), ByteSequence.from((String)seataConfigStr, (Charset)CharsetUtil.UTF_8)), configFuture));
            return (Boolean)configFuture.get();
        }
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        this.etcdConfigExecutor.execute(() -> EtcdConfiguration.complete(EtcdConfiguration.getClient().getKVClient().delete(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)), configFuture));
        return (Boolean)configFuture.get();
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        EtcdListener etcdListener = new EtcdListener(dataId, listener);
        CONFIG_LISTENERS_MAP.computeIfAbsent(dataId, key -> ConcurrentHashMap.newKeySet()).add(etcdListener);
        etcdListener.onProcessEvent(new ConfigurationChangeEvent());
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configListeners)) {
            for (ConfigurationChangeListener entry : configListeners) {
                ConfigurationChangeListener target = ((EtcdListener)entry).getTargetListener();
                if (!listener.equals(target)) continue;
                entry.onShutDown();
                configListeners.remove(entry);
                break;
            }
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)CONFIG_LISTENERS_MAP.get(dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Client getClient() {
        if (client != null) return client;
        Class<EtcdConfiguration> clazz = EtcdConfiguration.class;
        synchronized (EtcdConfiguration.class) {
            if (client != null) return client;
            client = Client.builder().endpoints(new String[]{FILE_CONFIG.getConfig("config.etcd3.serverAddr")}).build();
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private static <T> void complete(CompletableFuture<T> completableFuture, ConfigFuture configFuture) {
        block8: {
            try {
                T response = completableFuture.get();
                if (response instanceof GetResponse) {
                    ByteSequence value;
                    List keyValues = ((GetResponse)response).getKvs();
                    if (CollectionUtils.isNotEmpty((Collection)keyValues) && (value = ((KeyValue)keyValues.get(0)).getValue()) != null) {
                        configFuture.setResult((Object)value.toString(CharsetUtil.UTF_8));
                    }
                    break block8;
                }
                if (response instanceof PutResponse) {
                    configFuture.setResult((Object)Boolean.TRUE);
                    break block8;
                }
                if (response instanceof TxnResponse) {
                    boolean result = ((TxnResponse)response).isSucceeded();
                    if (result) {
                        configFuture.setResult((Object)Boolean.TRUE);
                    }
                    break block8;
                }
                if (response instanceof DeleteResponse) {
                    configFuture.setResult((Object)Boolean.TRUE);
                    break block8;
                }
                throw new ShouldNeverHappenException("unsupported response type");
            }
            catch (Exception e) {
                LOGGER.error("error occurred while completing the future{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private static void initSeataConfig() {
        String etcdConfigKey = EtcdConfiguration.getEtcdConfigKey();
        CompletableFuture future = EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)etcdConfigKey, (Charset)CharsetUtil.UTF_8));
        try {
            GetResponse getResponse = (GetResponse)future.get();
            List kvs = getResponse.getKvs();
            if (!kvs.isEmpty()) {
                seataConfig = ConfigProcessor.processConfig((String)new String(((KeyValue)kvs.get(0)).getValue().getBytes(), StandardCharsets.UTF_8), (String)EtcdConfiguration.getEtcdDataType());
                EtcdListener etcdListener = new EtcdListener(etcdConfigKey, null);
                CONFIG_LISTENERS_MAP.computeIfAbsent(etcdConfigKey, key -> new ConcurrentSet()).add(etcdListener);
                etcdListener.onProcessEvent(new ConfigurationChangeEvent());
            }
        }
        catch (Exception e) {
            LOGGER.error("init config properties error", (Throwable)e);
        }
    }

    private static String getEtcdConfigKey() {
        return FILE_CONFIG.getConfig("config.etcd3.key", DEFAULT_ETCD_CONFIG_KEY_VALUE);
    }

    private static String getEtcdDataType() {
        return ConfigProcessor.resolverConfigDataType((String)EtcdConfiguration.getEtcdConfigKey());
    }

    private static String getSeataConfigStr() {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enumeration = seataConfig.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = seataConfig.getProperty(key);
            sb.append(key).append("=").append(property).append("\n");
        }
        return sb.toString();
    }

    static {
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        CONFIG_LISTENERS_MAP = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>(8);
        seataConfig = new Properties();
    }

    private static class EtcdListener
    implements ConfigurationChangeListener {
        private final String dataId;
        private final ConfigurationChangeListener listener;
        private Watch.Watcher watcher;
        private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("etcdListener", 1));

        public EtcdListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        public void onShutDown() {
            this.watcher.close();
            this.getExecutorService().shutdownNow();
        }

        public void onChangeEvent(final ConfigurationChangeEvent event) {
            Watch watchClient = EtcdConfiguration.getClient().getWatchClient();
            this.watcher = watchClient.watch(ByteSequence.from((String)this.dataId, (Charset)CharsetUtil.UTF_8), new Watch.Listener(){

                public void onNext(WatchResponse watchResponse) {
                    if (dataId.equals(EtcdConfiguration.getEtcdConfigKey())) {
                        Properties seataConfigNew;
                        byte[] bytes = ((WatchEvent)watchResponse.getEvents().get(0)).getKeyValue().getValue().getBytes();
                        try {
                            seataConfigNew = ConfigProcessor.processConfig((String)new String(bytes, StandardCharsets.UTF_8), (String)EtcdConfiguration.getEtcdDataType());
                        }
                        catch (IOException e) {
                            LOGGER.error("load config properties error", (Throwable)e);
                            return;
                        }
                        for (Map.Entry entry : CONFIG_LISTENERS_MAP.entrySet()) {
                            String valueNew;
                            String key = (String)entry.getKey();
                            String valueOld = seataConfig.getProperty(key, "");
                            if (valueOld.equals(valueNew = seataConfigNew.getProperty(key, ""))) continue;
                            for (ConfigurationChangeListener changeListener : (Set)entry.getValue()) {
                                event.setDataId(key).setNewValue(valueNew);
                                ConfigurationChangeListener listener = ((EtcdListener)changeListener).getTargetListener();
                                listener.onProcessEvent(event);
                            }
                        }
                        seataConfig = seataConfigNew;
                        return;
                    }
                    try {
                        GetResponse getResponse = (GetResponse)EtcdConfiguration.getClient().getKVClient().get(ByteSequence.from((String)dataId, (Charset)CharsetUtil.UTF_8)).get();
                        List keyValues = getResponse.getKvs();
                        if (CollectionUtils.isNotEmpty((Collection)keyValues)) {
                            event.setDataId(dataId).setNewValue(((KeyValue)keyValues.get(0)).getValue().toString(CharsetUtil.UTF_8));
                            listener.onChangeEvent(event);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error occurred while getting value{}", (Object)e.getMessage(), (Object)e);
                    }
                }

                public void onError(Throwable throwable) {
                }

                public void onCompleted() {
                }
            });
        }

        public ExecutorService getExecutorService() {
            return this.executor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EtcdListener that = (EtcdListener)o;
            return Objects.equals(this.dataId, that.dataId) && Objects.equals(this.listener, that.listener) && Objects.equals(this.watcher, that.watcher) && Objects.equals(this.executor, that.executor);
        }

        public int hashCode() {
            return Objects.hash(this.dataId, this.listener, this.watcher, this.executor);
        }
    }
}

