/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arquillian;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Before;

class QuarkusJunitCallbacks {
    QuarkusJunitCallbacks() {
    }

    static void invokeJunitBefores(Object testInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (testInstance != null) {
            ArrayList<Method> befores = new ArrayList<Method>();
            QuarkusJunitCallbacks.collectCallbacks(testInstance.getClass(), befores, testInstance.getClass().getClassLoader().loadClass(Before.class.getName()));
            for (Method before : befores) {
                before.invoke(testInstance, new Object[0]);
            }
        }
    }

    static void invokeJunitAfters(Object testInstance) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException {
        if (testInstance != null) {
            ArrayList<Method> afters = new ArrayList<Method>();
            QuarkusJunitCallbacks.collectCallbacks(testInstance.getClass(), afters, testInstance.getClass().getClassLoader().loadClass(After.class.getName()));
            for (Method after : afters) {
                after.invoke(testInstance, new Object[0]);
            }
        }
    }

    private static void collectCallbacks(Class<?> testClass, List<Method> callbacks, Class<? extends Annotation> annotation) {
        Arrays.stream(testClass.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(annotation)).forEach(callbacks::add);
        Class<?> superClass = testClass.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            QuarkusJunitCallbacks.collectCallbacks(superClass, callbacks, annotation);
        }
    }
}

