/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arquillian;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arquillian.QuarkusConfiguration;
import io.quarkus.bootstrap.app.AdditionalDependency;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.bootstrap.app.StartupAction;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildContext;
import io.quarkus.builder.BuildStep;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.test.common.TestInstantiator;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.spi.context.annotation.DeploymentScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class QuarkusDeployableContainer
implements DeployableContainer<QuarkusConfiguration> {
    private static final Logger LOGGER = Logger.getLogger(QuarkusDeployableContainer.class);
    @Inject
    @DeploymentScoped
    private InstanceProducer<RunningQuarkusApplication> runningApp;
    @Inject
    @DeploymentScoped
    private InstanceProducer<Path> deploymentLocation;
    @Inject
    @DeploymentScoped
    private InstanceProducer<ClassLoader> appClassloader;
    @Inject
    private Instance<TestClass> testClass;
    static Object testInstance;
    static ClassLoader old;
    private QuarkusConfiguration configuration;

    public Class<QuarkusConfiguration> getConfigurationClass() {
        return QuarkusConfiguration.class;
    }

    public void setup(QuarkusConfiguration configuration) {
        this.configuration = configuration;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        old = Thread.currentThread().getContextClassLoader();
        if (this.testClass.get() == null) {
            throw new IllegalStateException("Test class not available");
        }
        final Class testJavaClass = ((TestClass)this.testClass.get()).getJavaClass();
        boolean skipLibraries = Boolean.getBoolean("io.quarkus.arquillian.skip-libraries");
        try {
            Path appLocation;
            Path tmpLocation = Files.createTempDirectory("quarkus-arquillian-test", new FileAttribute[0]);
            this.deploymentLocation.set((Object)tmpLocation);
            ((ExplodedExporter)archive.as(ExplodedExporter.class)).exportExplodedInto(tmpLocation.toFile());
            HashSet libraries = new HashSet();
            if (archive instanceof WebArchive) {
                appLocation = tmpLocation.resolve("app").toAbsolutePath();
                if (!skipLibraries && Files.exists(tmpLocation.resolve("WEB-INF/lib"), new LinkOption[0])) {
                    Files.move(tmpLocation.resolve("WEB-INF/lib"), tmpLocation.resolve("lib"), new CopyOption[0]);
                }
                if (Files.exists(tmpLocation.resolve("WEB-INF/classes"), new LinkOption[0])) {
                    Files.move(tmpLocation.resolve("WEB-INF/classes"), appLocation, new CopyOption[0]);
                } else {
                    Files.createDirectory(appLocation, new FileAttribute[0]);
                }
                if (Files.exists(tmpLocation.resolve("META-INF"), new LinkOption[0])) {
                    if (Files.exists(appLocation.resolve("META-INF"), new LinkOption[0])) {
                        try (Stream<Path> fileTreeElements = Files.walk(tmpLocation.resolve("META-INF"), 2, new FileVisitOption[0]);){
                            fileTreeElements.forEach(p -> {
                                try {
                                    Files.createFile(p, new FileAttribute[0]);
                                }
                                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            });
                        }
                    } else {
                        Files.move(tmpLocation.resolve("META-INF"), appLocation.resolve("META-INF"), new CopyOption[0]);
                    }
                }
                if (Files.exists(tmpLocation.resolve("WEB-INF"), new LinkOption[0])) {
                    Files.move(tmpLocation.resolve("WEB-INF"), appLocation.resolve("WEB-INF"), new CopyOption[0]);
                }
                if (Files.exists(tmpLocation.resolve("lib"), new LinkOption[0])) {
                    try (Stream<Path> libs = Files.walk(tmpLocation.resolve("lib"), 1, new FileVisitOption[0]);){
                        libs.forEach(i -> {
                            if (i.getFileName().toString().endsWith(".jar")) {
                                libraries.add(i);
                            }
                        });
                    }
                }
            } else {
                appLocation = tmpLocation;
            }
            ArrayList<1> customizers = new ArrayList<1>();
            customizers.add(new Consumer<BuildChainBuilder>(){

                @Override
                public void accept(BuildChainBuilder buildChainBuilder) {
                    buildChainBuilder.addBuildStep(new BuildStep(){

                        public void execute(BuildContext context) {
                            context.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf((Class)testJavaClass));
                        }
                    }).produces(AdditionalBeanBuildItem.class).build();
                }
            });
            QuarkusBootstrap.Builder bootstrapBuilder = QuarkusBootstrap.builder().setApplicationRoot(appLocation).setProjectRoot(appLocation).setIsolateDeployment(false).setFlatClassPath(true).setMode(QuarkusBootstrap.Mode.TEST);
            for (Path i2 : libraries) {
                bootstrapBuilder.addAdditionalApplicationArchive(new AdditionalDependency(i2, false, true));
            }
            CuratedApplication curatedApplication = bootstrapBuilder.build().bootstrap();
            AugmentActionImpl augmentAction = new AugmentActionImpl(curatedApplication, customizers);
            StartupAction app = augmentAction.createInitialRuntimeApplication();
            RunningQuarkusApplication runningQuarkusApplication = app.run(new String[0]);
            this.appClassloader.set((Object)runningQuarkusApplication.getClassLoader());
            this.runningApp.set((Object)runningQuarkusApplication);
            Thread.currentThread().setContextClassLoader(runningQuarkusApplication.getClassLoader());
            testInstance = TestInstantiator.instantiateTest((Class)testJavaClass, (ClassLoader)runningQuarkusApplication.getClassLoader());
            if (Boolean.getBoolean("io.quarkus.arquillian.copy-fields")) {
                Class<?> dest = testInstance.getClass();
                Class source = ((TestClass)this.testClass.get()).getJavaClass();
                while (source != Object.class) {
                    for (Field f : source.getDeclaredFields()) {
                        try {
                            if (!Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
                            Field df = dest.getDeclaredField(f.getName());
                            df.setAccessible(true);
                            f.setAccessible(true);
                            df.set(null, f.get(null));
                        }
                        catch (Exception e) {
                            LOGGER.error((Object)"Failed to copy static field", (Throwable)e);
                        }
                    }
                    source = source.getSuperclass();
                    dest = dest.getSuperclass();
                }
            }
        }
        catch (Throwable t) {
            Throwable nt;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ObjectOutputStream a = new ObjectOutputStream(out);){
                a.writeObject(t);
                a.close();
                nt = (Throwable)new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())).readObject();
            }
            catch (Exception e) {
                throw new DeploymentException("Unable to start the runtime runner", t);
            }
            throw new DeploymentException("Unable to start the runtime runner", nt);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        ProtocolMetaData metadata = new ProtocolMetaData();
        String testUri = TestHTTPResourceManager.getUri((RunningQuarkusApplication)((RunningQuarkusApplication)this.runningApp.get()));
        System.setProperty("test.url", testUri);
        URI uri = URI.create(testUri);
        HTTPContext httpContext = new HTTPContext(uri.getHost(), uri.getPort());
        httpContext.add(new Servlet("dummy", "/"));
        metadata.addContext((Object)httpContext);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(Archive<?> archive) throws DeploymentException {
        block9: {
            try {
                RunningQuarkusApplication runner = (RunningQuarkusApplication)this.runningApp.get();
                if (runner != null) {
                    Thread.currentThread().setContextClassLoader(((RunningQuarkusApplication)this.runningApp.get()).getClassLoader());
                }
                testInstance = null;
                Path location = (Path)this.deploymentLocation.get();
                if (location != null) {
                    try {
                        Files.walkFileTree(location, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                Files.delete(file);
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                Files.delete(dir);
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                    catch (IOException e) {
                        LOGGER.warn((Object)("Unable to delete the deployment dir: " + location), (Throwable)e);
                    }
                }
                if (runner == null) break block9;
                try {
                    runner.close();
                }
                catch (Exception e) {
                    throw new DeploymentException("Unable to close the runtime runner", (Throwable)e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Quarkus");
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException();
    }
}

