/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.ant.types;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class EmbeddedServerInfo {
    private final String serverName;
    private final File userDir;
    private final File outputDir;

    public EmbeddedServerInfo(String serverName, File userDir, File outputDir) {
        this.serverName = serverName;
        this.userDir = userDir;
        this.outputDir = outputDir;
    }

    public String getServerName() {
        return this.serverName;
    }

    public File getUserDir() {
        return this.userDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public boolean equals(EmbeddedServerInfo info) {
        return this.serverName.equals(info.serverName) && this.areFilesEqual(this.userDir, info.userDir) && this.areFilesEqual(this.outputDir, info.outputDir);
    }

    private boolean areFilesEqual(File file1, File file2) {
        if (file1 != null && file2 != null) {
            return file1.getAbsolutePath().equals(file2.getAbsolutePath());
        }
        return file1 == null && file2 == null;
    }

    public static class EmbeddedServerClassLoaders {
        private static final Map<URL, URLClassLoader> CLASSLOADERS = new HashMap<URL, URLClassLoader>();

        public static URLClassLoader get(URL url) {
            for (Map.Entry<URL, URLClassLoader> entry : CLASSLOADERS.entrySet()) {
                URL entryUrl = entry.getKey();
                if (!url.equals(entryUrl)) continue;
                return entry.getValue();
            }
            return null;
        }

        public static void put(URL url, URLClassLoader classloader) {
            CLASSLOADERS.put(url, classloader);
        }
    }

    public static class EmbeddedServers {
        private static final Map<EmbeddedServerInfo, Object> EMBEDDED_SERVERS = new HashMap<EmbeddedServerInfo, Object>();

        public static Object get(EmbeddedServerInfo info) {
            for (Map.Entry<EmbeddedServerInfo, Object> entry : EMBEDDED_SERVERS.entrySet()) {
                EmbeddedServerInfo serverInfo = entry.getKey();
                if (!serverInfo.equals(info)) continue;
                return entry.getValue();
            }
            return null;
        }

        public static void put(EmbeddedServerInfo info, Object server) {
            EMBEDDED_SERVERS.put(info, server);
        }
    }
}

