/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.minio.BucketExistsArgs;
import io.minio.CloseableIterator;
import io.minio.ComposeObjectArgs;
import io.minio.CopyObjectArgs;
import io.minio.DeleteBucketEncryptionArgs;
import io.minio.DeleteBucketLifecycleArgs;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.DeleteBucketPolicyArgs;
import io.minio.DeleteBucketReplicationArgs;
import io.minio.DeleteBucketTagsArgs;
import io.minio.DeleteObjectLockConfigurationArgs;
import io.minio.DeleteObjectTagsArgs;
import io.minio.DisableObjectLegalHoldArgs;
import io.minio.DownloadObjectArgs;
import io.minio.EnableObjectLegalHoldArgs;
import io.minio.GetBucketEncryptionArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.GetBucketPolicyArgs;
import io.minio.GetBucketReplicationArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.GetBucketVersioningArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectLockConfigurationArgs;
import io.minio.GetObjectResponse;
import io.minio.GetObjectRetentionArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.IsObjectLegalHoldEnabledArgs;
import io.minio.ListBucketsArgs;
import io.minio.ListObjectsArgs;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioAsyncClient;
import io.minio.ObjectWriteResponse;
import io.minio.PostPolicy;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RemoveObjectsArgs;
import io.minio.RestoreObjectArgs;
import io.minio.Result;
import io.minio.SelectObjectContentArgs;
import io.minio.SelectResponseStream;
import io.minio.SetBucketEncryptionArgs;
import io.minio.SetBucketLifecycleArgs;
import io.minio.SetBucketNotificationArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.SetBucketReplicationArgs;
import io.minio.SetBucketTagsArgs;
import io.minio.SetBucketVersioningArgs;
import io.minio.SetObjectLockConfigurationArgs;
import io.minio.SetObjectRetentionArgs;
import io.minio.SetObjectTagsArgs;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.UploadObjectArgs;
import io.minio.UploadSnowballObjectsArgs;
import io.minio.credentials.Provider;
import io.minio.errors.BucketPolicyTooLargeException;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.ServerException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteError;
import io.minio.messages.Item;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.NotificationRecords;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.ReplicationConfiguration;
import io.minio.messages.Retention;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Tags;
import io.minio.messages.VersioningConfiguration;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class MinioClient {
    private MinioAsyncClient asyncClient = null;

    private MinioClient(MinioAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    protected MinioClient(MinioClient client) {
        this.asyncClient = client.asyncClient;
    }

    public StatObjectResponse statObject(StatObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.statObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public GetObjectResponse getObject(GetObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void downloadObject(DownloadObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.downloadObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public ObjectWriteResponse copyObject(CopyObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.copyObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public ObjectWriteResponse composeObject(ComposeObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.composeObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public String getPresignedObjectUrl(GetPresignedObjectUrlArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, XmlParserException, ServerException {
        return this.asyncClient.getPresignedObjectUrl(args);
    }

    public Map<String, String> getPresignedPostFormData(PostPolicy policy) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.asyncClient.getPresignedPostFormData(policy);
    }

    public void removeObject(RemoveObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.removeObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public Iterable<Result<DeleteError>> removeObjects(RemoveObjectsArgs args) {
        return this.asyncClient.removeObjects(args);
    }

    public void restoreObject(RestoreObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.restoreObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public Iterable<Result<Item>> listObjects(ListObjectsArgs args) {
        return this.asyncClient.listObjects(args);
    }

    public List<Bucket> listBuckets() throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.listBuckets().get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public List<Bucket> listBuckets(ListBucketsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.listBuckets(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public boolean bucketExists(BucketExistsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.bucketExists(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return false;
        }
    }

    public void makeBucket(MakeBucketArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.makeBucket(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void setBucketVersioning(SetBucketVersioningArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketVersioning(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public VersioningConfiguration getBucketVersioning(GetBucketVersioningArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketVersioning(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setObjectLockConfiguration(SetObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setObjectLockConfiguration(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteObjectLockConfiguration(DeleteObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteObjectLockConfiguration(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public ObjectLockConfiguration getObjectLockConfiguration(GetObjectLockConfigurationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getObjectLockConfiguration(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setObjectRetention(SetObjectRetentionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setObjectRetention(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public Retention getObjectRetention(GetObjectRetentionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getObjectRetention(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void enableObjectLegalHold(EnableObjectLegalHoldArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.enableObjectLegalHold(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void disableObjectLegalHold(DisableObjectLegalHoldArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.disableObjectLegalHold(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public boolean isObjectLegalHoldEnabled(IsObjectLegalHoldEnabledArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.isObjectLegalHoldEnabled(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return false;
        }
    }

    public void removeBucket(RemoveBucketArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.removeBucket(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public ObjectWriteResponse putObject(PutObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.putObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public ObjectWriteResponse uploadObject(UploadObjectArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.uploadObject(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public String getBucketPolicy(GetBucketPolicyArgs args) throws BucketPolicyTooLargeException, ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketPolicy(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return "";
        }
    }

    public void setBucketPolicy(SetBucketPolicyArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketPolicy(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteBucketPolicy(DeleteBucketPolicyArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteBucketPolicy(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void setBucketLifecycle(SetBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketLifecycle(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteBucketLifecycle(DeleteBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteBucketLifecycle(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public LifecycleConfiguration getBucketLifecycle(GetBucketLifecycleArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketLifecycle(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public NotificationConfiguration getBucketNotification(GetBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketNotification(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setBucketNotification(SetBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketNotification(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteBucketNotification(DeleteBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteBucketNotification(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public ReplicationConfiguration getBucketReplication(GetBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketReplication(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setBucketReplication(SetBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketReplication(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteBucketReplication(DeleteBucketReplicationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteBucketReplication(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public CloseableIterator<Result<NotificationRecords>> listenBucketNotification(ListenBucketNotificationArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.asyncClient.listenBucketNotification(args);
    }

    public SelectResponseStream selectObjectContent(SelectObjectContentArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        return this.asyncClient.selectObjectContent(args);
    }

    public void setBucketEncryption(SetBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketEncryption(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public SseConfiguration getBucketEncryption(GetBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketEncryption(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void deleteBucketEncryption(DeleteBucketEncryptionArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteBucketEncryption(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public Tags getBucketTags(GetBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getBucketTags(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setBucketTags(SetBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setBucketTags(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteBucketTags(DeleteBucketTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteBucketTags(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public Tags getObjectTags(GetObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.getObjectTags(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setObjectTags(SetObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.setObjectTags(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public void deleteObjectTags(DeleteObjectTagsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            this.asyncClient.deleteObjectTags(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
        }
    }

    public ObjectWriteResponse uploadSnowballObjects(UploadSnowballObjectsArgs args) throws ErrorResponseException, InsufficientDataException, InternalException, InvalidKeyException, InvalidResponseException, IOException, NoSuchAlgorithmException, ServerException, XmlParserException {
        try {
            return this.asyncClient.uploadSnowballObjects(args).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.asyncClient.throwEncapsulatedException(e);
            return null;
        }
    }

    public void setTimeout(long connectTimeout, long writeTimeout, long readTimeout) {
        this.asyncClient.setTimeout(connectTimeout, writeTimeout, readTimeout);
    }

    @SuppressFBWarnings(value={"SIC"}, justification="Should not be used in production anyways.")
    public void ignoreCertCheck() throws KeyManagementException, NoSuchAlgorithmException {
        this.asyncClient.ignoreCertCheck();
    }

    public void setAppInfo(String name, String version) {
        this.asyncClient.setAppInfo(name, version);
    }

    public void traceOn(OutputStream traceStream) {
        this.asyncClient.traceOn(traceStream);
    }

    public void traceOff() throws IOException {
        this.asyncClient.traceOff();
    }

    @Deprecated
    public void enableAccelerateEndpoint() {
        this.asyncClient.enableAccelerateEndpoint();
    }

    @Deprecated
    public void disableAccelerateEndpoint() {
        this.asyncClient.disableAccelerateEndpoint();
    }

    public void enableDualStackEndpoint() {
        this.asyncClient.enableDualStackEndpoint();
    }

    public void disableDualStackEndpoint() {
        this.asyncClient.disableDualStackEndpoint();
    }

    public void enableVirtualStyleEndpoint() {
        this.asyncClient.enableVirtualStyleEndpoint();
    }

    public void disableVirtualStyleEndpoint() {
        this.asyncClient.disableVirtualStyleEndpoint();
    }

    public void setAwsS3Prefix(String awsS3Prefix) {
        this.asyncClient.setAwsS3Prefix(awsS3Prefix);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private MinioAsyncClient.Builder asyncClientBuilder = MinioAsyncClient.builder();

        public Builder endpoint(String endpoint) {
            this.asyncClientBuilder.endpoint(endpoint);
            return this;
        }

        public Builder endpoint(String endpoint, int port, boolean secure) {
            this.asyncClientBuilder.endpoint(endpoint, port, secure);
            return this;
        }

        public Builder endpoint(URL url) {
            this.asyncClientBuilder.endpoint(url);
            return this;
        }

        public Builder endpoint(HttpUrl url) {
            this.asyncClientBuilder.endpoint(url);
            return this;
        }

        public Builder region(String region) {
            this.asyncClientBuilder.region(region);
            return this;
        }

        public Builder credentials(String accessKey, String secretKey) {
            this.asyncClientBuilder.credentials(accessKey, secretKey);
            return this;
        }

        public Builder credentialsProvider(Provider provider) {
            this.asyncClientBuilder.credentialsProvider(provider);
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            this.asyncClientBuilder.httpClient(httpClient);
            return this;
        }

        public MinioClient build() {
            MinioAsyncClient asyncClient = this.asyncClientBuilder.build();
            return new MinioClient(asyncClient);
        }
    }
}

