/*
 * MinIO Java SDK for Amazon S3 Compatible Cloud Storage, (C) 2015 MinIO, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.minio;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/** A singleton bucket/region cache map. */
enum AwsRegionCache {
  INSTANCE;
  private final Map<String, String> regionMap = new ConcurrentHashMap<>();

  /** Sets bucket name and its region. */
  public void set(String bucketName, String region) {
    this.regionMap.put(bucketName, region);
  }

  /** Gets region of bucket name. */
  public String get(String bucketName) {
    return this.regionMap.get(bucketName);
  }

  /** Removes bucket name and its region. */
  public void remove(String bucketName) {
    if (bucketName != null) {
      this.regionMap.remove(bucketName);
    }
  }
}
