/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter;

import io.github.tonycody.maven.plugin.sorter.SorterHandler;
import io.github.tonycody.maven.plugin.sorter.logger.MavenLogger;
import io.github.tonycody.maven.plugin.sorter.logger.SorterLogger;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.vavr.API;
import io.vavr.CheckedRunnable;
import io.vavr.control.Try;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractParentMojo
extends AbstractMojo {
    private final SorterHandler SORTER_HANDLER = SorterHandler.getInstance();
    @Parameter(property="maven.sorter.pom", defaultValue="${project.file}")
    File pom;
    @Parameter(property="maven.sorter.backup", defaultValue="true")
    boolean backup;
    @Parameter(property="maven.sorter.outputDirectory", defaultValue="${project.build.directory}/.sorted")
    File outputDirectory;
    @Parameter(property="maven.sorter.encoding", defaultValue="${project.build.sourceEncoding}")
    String encoding;
    @Parameter(property="maven.sorter.lineSeparator", defaultValue="${line.separator}")
    String lineSeparator;
    @Parameter(property="maven.sorter.expandEmptyElements", defaultValue="true")
    boolean expandEmptyElements;
    @Parameter(property="maven.sorter.spaceBeforeCloseEmptyElement", defaultValue="false")
    boolean spaceBeforeCloseEmptyElement;
    @Parameter(property="maven.sorter.keepBlankLines", defaultValue="true")
    boolean keepBlankLines;
    @Parameter(property="maven.sorter.nrOfIndentSpace", defaultValue="4")
    int nrOfIndentSpace;
    @Parameter(property="maven.sorter.ignoreLineSeparators", defaultValue="true")
    boolean ignoreLineSeparators;
    @Parameter(property="maven.sorter.indentBlankLines", defaultValue="false")
    boolean indentBlankLines;
    @Parameter(property="maven.sorter.indentSchemaLocation", defaultValue="false")
    boolean indentSchemaLocation;
    @Parameter(property="maven.sorter.predefinedSortOrder", defaultValue="recommended_2008_06")
    String predefinedSortOrder;
    @Parameter(property="maven.sorter.sortOrderFile")
    String sortOrderFile;
    @Parameter(property="maven.sorter.sortDependencies")
    String sortDependencies;
    @Parameter(property="maven.sorter.sortDependencyExclusions")
    String sortDependencyExclusions;
    @Parameter(property="maven.sorter.sortDependencyManagement")
    String sortDependencyManagement;
    @Parameter(property="maven.sorter.sortPlugins")
    String sortPlugins;
    @Parameter(property="maven.sorter.sortProperties", defaultValue="false")
    boolean sortProperties;
    @Parameter(property="maven.sorter.sortModules", defaultValue="false")
    boolean sortModules;
    @Parameter(property="maven.sorter.sortExecutions", defaultValue="false")
    boolean sortExecutions;
    @Parameter(property="maven.sorter.keepTimestamp", defaultValue="false")
    boolean keepTimestamp;
    @Parameter(property="maven.sorter.skip", defaultValue="false")
    private boolean skip;

    AbstractParentMojo() {
    }

    public void execute() throws MojoFailureException {
        CheckedRunnable runnable = (CheckedRunnable)API.Match((Object)this.skip).of(new API.Match.Case[]{API.Case((API.Match.Pattern0)API.$((Object)true), () -> this.getLog().info((CharSequence)"Skipping sort")), API.Case((API.Match.Pattern0)API.$((Object)false), () -> {
            PluginParameters pluginParameters = this.buildParameters();
            this.SORTER_HANDLER.initialize((SorterLogger)new MavenLogger(this.getLog()), pluginParameters);
            this.invoke(this.SORTER_HANDLER);
        })});
        Try.run((CheckedRunnable)runnable);
    }

    protected abstract void invoke(SorterHandler var1);

    protected abstract PluginParameters buildParameters();
}

