/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.wrapper.operation;

import io.github.tonycody.maven.plugin.sorter.wrapper.content.Wrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.HierarchyWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.HierarchyWrapperOperation;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.Node;

class ToStringOperation
implements HierarchyWrapperOperation {
    private static final String INDENT = "  ";
    private static final int INDENT_LENGTH = "  ".length();
    private final StringBuilder builder;
    private final String baseIndent;
    private boolean processFirstOtherContent;

    ToStringOperation() {
        this.builder = new StringBuilder();
        this.baseIndent = INDENT;
    }

    private ToStringOperation(StringBuilder builder, String baseIndent) {
        this.builder = builder;
        this.baseIndent = INDENT + baseIndent;
    }

    @Override
    public void startOfProcess() {
        String previousBaseIndent = this.baseIndent.substring(INDENT_LENGTH);
        this.builder.append(previousBaseIndent).append("HierarchyWrapper{\n");
        this.processFirstOtherContent = true;
    }

    @Override
    public void processOtherContent(Wrapper<Node> content) {
        if (this.processFirstOtherContent) {
            this.builder.append(this.baseIndent).append("otherContentList=").append("\n");
            this.processFirstOtherContent = false;
        }
        this.builder.append(content.toString(this.baseIndent)).append("\n");
    }

    @Override
    public void processElement(Wrapper<Element> elementWrapper) {
        this.builder.append(this.baseIndent).append("elementContent=").append(elementWrapper).append("\n");
    }

    @Override
    public void manipulateChildElements(List<HierarchyWrapper> children) {
        if (!children.isEmpty()) {
            this.builder.append(this.baseIndent).append("children=").append("\n");
        }
    }

    @Override
    public HierarchyWrapperOperation createSubOperation() {
        return new ToStringOperation(this.builder, this.baseIndent);
    }

    @Override
    public void endOfProcess() {
        this.builder.append(this.baseIndent).append('}').append("\n");
    }

    public String toString() {
        return this.builder.toString();
    }
}

