/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.wrapper;

import io.github.tonycody.maven.plugin.sorter.content.IgnoreSectionToken;
import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.util.FileHelper;
import io.github.tonycody.maven.plugin.sorter.wrapper.ElementSortOrderMap;
import io.github.tonycody.maven.plugin.sorter.wrapper.ElementWrapperCreator;
import io.github.tonycody.maven.plugin.sorter.wrapper.TextWrapperCreator;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.UnsortedWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.content.Wrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.HierarchyRootWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.WrapperFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class WrapperFactoryImpl
implements WrapperFactory {
    private static final int SORT_ORDER_INCREMENT = 100;
    private static final int SORT_ORDER_BASE = 1000;
    private final FileHelper fileUtil;
    private final ElementSortOrderMap elementSortOrderMap = new ElementSortOrderMap();
    private final ElementWrapperCreator elementWrapperCreator = new ElementWrapperCreator(this.elementSortOrderMap);
    private final TextWrapperCreator textWrapperCreator = new TextWrapperCreator();

    public WrapperFactoryImpl(FileHelper fileUtil) {
        this.fileUtil = fileUtil;
    }

    public void setup(PluginParameters pluginParameters) {
        this.elementWrapperCreator.setup(pluginParameters);
        this.textWrapperCreator.setup(pluginParameters);
    }

    @Override
    public HierarchyRootWrapper createFromRootElement(Element rootElement) {
        this.initializeSortOrderMap();
        return new HierarchyRootWrapper(this.create(rootElement));
    }

    private void initializeSortOrderMap() {
        try {
            Document document = this.createDocumentFromDefaultSortOrderFile();
            this.addElementsToSortOrderMap(document.getRootElement(), 1000);
        }
        catch (IOException | DocumentException | SAXException e) {
            throw new FailureException(e.getMessage(), e);
        }
    }

    Document createDocumentFromDefaultSortOrderFile() throws IOException, DocumentException, SAXException {
        try (StringReader reader = new StringReader(this.fileUtil.getDefaultSortOrderXml());){
            SAXReader parser = new SAXReader();
            parser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document document = parser.read((Reader)reader);
            return document;
        }
    }

    private void addElementsToSortOrderMap(Element element, int baseSortOrder) {
        this.elementSortOrderMap.addElement(element, baseSortOrder);
        List castToChildElementList = element.elements();
        int sortOrder = baseSortOrder;
        for (Element child : castToChildElementList) {
            this.addElementsToSortOrderMap(child, sortOrder += 100);
        }
    }

    @Override
    public <T extends Node> Wrapper<T> create(T content) {
        if (content instanceof Element) {
            return this.elementWrapperCreator.createWrapper((Element)content);
        }
        if (content instanceof Comment) {
            return new UnsortedWrapper<T>(content);
        }
        if (content instanceof Text) {
            return this.textWrapperCreator.createWrapper((Text)content);
        }
        if (content instanceof ProcessingInstruction && "sortpom".equals(content.getName())) {
            return new UnsortedWrapper<IgnoreSectionToken>(IgnoreSectionToken.from((ProcessingInstruction)content));
        }
        return new UnsortedWrapper<T>(content);
    }
}

