/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.util;

public final class XmlOrderedResult {
    private final boolean ordered;
    private final String errorMessage;

    private XmlOrderedResult(boolean ordered, String errorMessage) {
        this.ordered = ordered;
        this.errorMessage = errorMessage;
    }

    public static XmlOrderedResult ordered() {
        return new XmlOrderedResult(true, "");
    }

    public static XmlOrderedResult nameDiffers(String originalElementName, String newElementName) {
        return new XmlOrderedResult(false, String.format("The xml element <%s> should be placed before <%s>", newElementName, originalElementName));
    }

    public static XmlOrderedResult childElementDiffers(String name, int originalSize, int newSize) {
        return new XmlOrderedResult(false, String.format("The xml element <%s> with %s child elements should be placed before element <%s> with %s child elements", name, newSize, name, originalSize));
    }

    public static XmlOrderedResult textContentDiffers(String name, String originalElementText, String newElementText) {
        return new XmlOrderedResult(false, String.format("The xml element <%s>%s</%s> should be placed before <%s>%s</%s>", name, newElementText, name, name, originalElementText, name));
    }

    public static XmlOrderedResult lineDiffers(int lineNumber, String sortedXmlLine) {
        return new XmlOrderedResult(false, String.format("The line %d is not considered sorted, should be %s", lineNumber, sortedXmlLine));
    }

    public static XmlOrderedResult lineSeparatorCharactersDiffer() {
        return new XmlOrderedResult(false, "The line separator characters differ from sorted pom");
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

