/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.processinstruction;

import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import io.github.tonycody.maven.plugin.sorter.logger.SorterLogger;
import io.github.tonycody.maven.plugin.sorter.processinstruction.IgnoredSectionsStore;
import io.github.tonycody.maven.plugin.sorter.processinstruction.SorterPiScanner;

public class XmlProcessingInstructionParser {
    private final IgnoredSectionsStore ignoredSectionsStore = new IgnoredSectionsStore();
    private String originalXml;
    private SorterLogger logger;
    private boolean containsIgnoredSections = false;

    public void setup(SorterLogger logger) {
        this.logger = logger;
    }

    public void scanForIgnoredSections(String originalXml) {
        this.originalXml = originalXml;
        SorterPiScanner sortpomPiScanner = new SorterPiScanner(this.logger);
        sortpomPiScanner.scan(originalXml);
        if (sortpomPiScanner.isScanError()) {
            throw new FailureException(sortpomPiScanner.getFirstError());
        }
        this.containsIgnoredSections = sortpomPiScanner.containsIgnoredSections();
    }

    public boolean existsIgnoredSections() {
        return this.containsIgnoredSections;
    }

    public String replaceIgnoredSections() {
        if (this.containsIgnoredSections) {
            return this.ignoredSectionsStore.replaceIgnoredSections(this.originalXml);
        }
        return this.originalXml;
    }

    public String revertIgnoredSections(String sortedXml) {
        if (this.containsIgnoredSections) {
            return this.ignoredSectionsStore.revertIgnoredSections(sortedXml);
        }
        return sortedXml;
    }
}

