/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.processinstruction;

import io.github.tonycody.maven.plugin.sorter.logger.SorterLogger;
import io.github.tonycody.maven.plugin.sorter.processinstruction.InstructionType;
import java.util.regex.Matcher;

class SorterPiScanner {
    private final SorterLogger logger;
    private InstructionType expectedNextInstruction = InstructionType.IGNORE;
    private String errorString;
    private boolean containsIgnoredSections = false;

    public SorterPiScanner(SorterLogger logger) {
        this.logger = logger;
    }

    public void scan(String originalXml) {
        Matcher matcher = InstructionType.INSTRUCTION_PATTERN.matcher(originalXml);
        while (matcher.find()) {
            this.scanOneInstruction(matcher.group(1));
            this.containsIgnoredSections = true;
        }
        if (this.expectedNextInstruction != InstructionType.IGNORE) {
            this.addError(String.format("Xml processing instructions for sortpom was not properly terminated. Every <?sortpom %s?> must be followed with <?sortpom %s?>", new Object[]{InstructionType.IGNORE, InstructionType.RESUME}));
        }
    }

    private void scanOneInstruction(String instruction) {
        if (!InstructionType.containsType(instruction)) {
            this.addError(String.format("Xml contained unknown sortpom instruction '%s'. Please use <?sortpom %s?> or <?sortpom %s?>", new Object[]{instruction, InstructionType.IGNORE, InstructionType.RESUME}));
        } else if (!this.expectedNextInstruction.matches(instruction)) {
            this.addError(String.format("Xml contained unexpected sortpom instruction '%s'. Please use expected instruction <?sortpom %s?>", new Object[]{instruction, this.expectedNextInstruction}));
        } else {
            this.expectedNextInstruction = this.expectedNextInstruction.next();
        }
    }

    private void addError(String msg) {
        if (this.errorString == null) {
            this.errorString = msg;
        }
        this.logger.error(msg);
    }

    public boolean isScanError() {
        return this.errorString != null;
    }

    public String getFirstError() {
        return this.errorString;
    }

    public boolean containsIgnoredSections() {
        return this.containsIgnoredSections;
    }
}

