/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.parameter;

import io.github.tonycody.maven.plugin.sorter.parameter.DependencySortOrder;
import io.github.tonycody.maven.plugin.sorter.parameter.IndentCharacters;
import io.github.tonycody.maven.plugin.sorter.parameter.LineSeparatorUtil;
import io.github.tonycody.maven.plugin.sorter.parameter.VerifyFailOnType;
import io.github.tonycody.maven.plugin.sorter.parameter.VerifyFailType;
import java.io.File;

public class PluginParameters {
    public final File originalPom;
    public final boolean backup;
    public final File outputDirectory;
    public final String violationFilename;
    public final String encoding;
    public final LineSeparatorUtil lineSeparatorUtil;
    public final String indentCharacters;
    public final boolean expandEmptyElements;
    public final boolean spaceBeforeCloseEmptyElement;
    public final String predefinedSortOrder;
    public final String customSortOrderFile;
    public final DependencySortOrder sortDependencies;
    public final DependencySortOrder sortDependencyExclusions;
    public final DependencySortOrder sortDependencyManagement;
    public final DependencySortOrder sortPlugins;
    public final boolean sortProperties;
    public final boolean sortModules;
    public final boolean sortExecutions;
    public final boolean keepBlankLines;
    public final boolean indentBlankLines;
    public final boolean indentSchemaLocation;
    public final VerifyFailType verifyFailType;
    public final VerifyFailOnType verifyFailOn;
    public final boolean ignoreLineSeparators;
    public final boolean keepTimestamp;

    private PluginParameters(File originalPom, boolean backup, File outputDirectory, String violationFilename, String encoding, LineSeparatorUtil lineSeparatorUtil, boolean expandEmptyElements, boolean spaceBeforeCloseEmptyElement, boolean keepBlankLines, String indentCharacters, boolean indentBlankLines, boolean indentSchemaLocation, String predefinedSortOrder, String customSortOrderFile, DependencySortOrder sortDependencies, DependencySortOrder sortDependencyExclusions, DependencySortOrder sortDependencyManagement, DependencySortOrder sortPlugins, boolean sortProperties, boolean sortModules, boolean sortExecutions, VerifyFailType verifyFailType, VerifyFailOnType verifyFailOn, boolean ignoreLineSeparators, boolean keepTimestamp) {
        this.originalPom = originalPom;
        this.backup = backup;
        this.outputDirectory = outputDirectory;
        this.violationFilename = violationFilename;
        this.encoding = encoding;
        this.lineSeparatorUtil = lineSeparatorUtil;
        this.indentCharacters = indentCharacters;
        this.expandEmptyElements = expandEmptyElements;
        this.spaceBeforeCloseEmptyElement = spaceBeforeCloseEmptyElement;
        this.predefinedSortOrder = predefinedSortOrder;
        this.customSortOrderFile = customSortOrderFile;
        this.sortDependencies = sortDependencies;
        this.sortDependencyExclusions = sortDependencyExclusions;
        this.sortDependencyManagement = sortDependencyManagement;
        this.sortPlugins = sortPlugins;
        this.sortProperties = sortProperties;
        this.sortModules = sortModules;
        this.sortExecutions = sortExecutions;
        this.keepBlankLines = keepBlankLines;
        this.indentBlankLines = indentBlankLines;
        this.indentSchemaLocation = indentSchemaLocation;
        this.verifyFailType = verifyFailType;
        this.verifyFailOn = verifyFailOn;
        this.ignoreLineSeparators = ignoreLineSeparators;
        this.keepTimestamp = keepTimestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File originalPom;
        private boolean createBackupFile;
        private File outputDirectory;
        private String violationFilename;
        private String encoding;
        private LineSeparatorUtil lineSeparatorUtil;
        private String indentCharacters;
        private boolean indentBlankLines;
        private boolean indentSchemaLocation;
        private boolean expandEmptyElements;
        private boolean spaceBeforeCloseEmptyElement;
        private String predefinedSortOrder;
        private String customSortOrderFile;
        private DependencySortOrder sortDependencies;
        private DependencySortOrder sortDependencyExclusions;
        private DependencySortOrder sortDependencyManagement;
        private DependencySortOrder sortPlugins;
        private boolean sortProperties;
        private boolean sortModules;
        private boolean sortExecutions;
        private boolean keepBlankLines;
        private VerifyFailType verifyFailType;
        private VerifyFailOnType verifyFailOn;
        private boolean ignoreLineSeparators;
        private boolean keepTimestamp;

        private Builder() {
        }

        public Builder setOriginalPom(File originalPom) {
            this.originalPom = originalPom;
            return this;
        }

        public Builder setFileOutput(boolean createBackupFile, File outputDirectory, String violationFilename, boolean keepTimestamp) {
            this.createBackupFile = createBackupFile;
            this.outputDirectory = outputDirectory;
            this.violationFilename = violationFilename;
            this.keepTimestamp = keepTimestamp;
            return this;
        }

        public Builder setEncoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public Builder setFormatting(String lineSeparator, boolean expandEmptyElements, boolean spaceBeforeCloseEmptyElement, boolean keepBlankLines) {
            this.lineSeparatorUtil = new LineSeparatorUtil(lineSeparator);
            this.expandEmptyElements = expandEmptyElements;
            this.spaceBeforeCloseEmptyElement = spaceBeforeCloseEmptyElement;
            this.keepBlankLines = keepBlankLines;
            return this;
        }

        public Builder setIndent(int nrOfIndentSpace, boolean indentBlankLines, boolean indentSchemaLocation) {
            this.indentCharacters = new IndentCharacters(nrOfIndentSpace).getIndentCharacters();
            this.indentBlankLines = indentBlankLines;
            this.indentSchemaLocation = indentSchemaLocation;
            return this;
        }

        public Builder setSortOrder(String customSortOrderFile, String predefinedSortOrder) {
            this.customSortOrderFile = customSortOrderFile;
            this.predefinedSortOrder = predefinedSortOrder;
            return this;
        }

        public Builder setSortEntities(String sortDependencies, String sortDependencyExclusions, String sortDependencyManagement, String sortPlugins, boolean sortProperties, boolean sortModules, boolean sortExecutions) {
            this.sortDependencies = new DependencySortOrder(sortDependencies);
            this.sortDependencyExclusions = new DependencySortOrder(sortDependencyExclusions);
            this.sortDependencyManagement = new DependencySortOrder(sortDependencyManagement);
            this.sortPlugins = new DependencySortOrder(sortPlugins);
            this.sortProperties = sortProperties;
            this.sortModules = sortModules;
            this.sortExecutions = sortExecutions;
            return this;
        }

        public Builder setVerifyFail(String verifyFail, String verifyFailOn) {
            this.verifyFailType = VerifyFailType.fromString(verifyFail);
            this.verifyFailOn = VerifyFailOnType.fromString(verifyFailOn);
            return this;
        }

        public Builder setIgnoreLineSeparators(boolean ignoreLineSeparators) {
            this.ignoreLineSeparators = ignoreLineSeparators;
            return this;
        }

        public PluginParameters build() {
            return new PluginParameters(this.originalPom, this.createBackupFile, this.outputDirectory, this.violationFilename, this.encoding, this.lineSeparatorUtil, this.expandEmptyElements, this.spaceBeforeCloseEmptyElement, this.keepBlankLines, this.indentCharacters, this.indentBlankLines, this.indentSchemaLocation, this.predefinedSortOrder, this.customSortOrderFile, this.sortDependencies, this.sortDependencyExclusions, this.sortDependencyManagement, this.sortPlugins, this.sortProperties, this.sortModules, this.sortExecutions, this.verifyFailType, this.verifyFailOn, this.ignoreLineSeparators, this.keepTimestamp);
        }
    }
}

