/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.parameter;

import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class LineSeparatorUtil {
    private final String string;

    LineSeparatorUtil(String lineSeparatorString) {
        this.string = lineSeparatorString.replace("\\r", "\r").replace("\\n", "\n");
        if (this.isIllegalString()) {
            throw new FailureException("LineSeparator must be either \\n, \\r or \\r\\n, but separator characters were " + Arrays.toString(lineSeparatorString.getBytes(Charset.defaultCharset())));
        }
    }

    private boolean isIllegalString() {
        return !"\n".equalsIgnoreCase(this.string) && !"\r".equalsIgnoreCase(this.string) && !"\r\n".equalsIgnoreCase(this.string);
    }

    public String toString() {
        return this.string;
    }
}

