/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.parameter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class DependencySortOrder {
    private final String childElementNameList;
    private Collection<String> childElementNames;

    public DependencySortOrder(String childElementNameList) {
        this.childElementNameList = childElementNameList == null ? "" : childElementNameList;
    }

    public Collection<String> getChildElementNames() {
        if (this.childElementNames == null) {
            this.childElementNames = Collections.unmodifiableList(Arrays.asList(this.parseChildElementNameList()));
        }
        return this.childElementNames;
    }

    private String[] parseChildElementNameList() {
        String list = this.childElementNameList.replaceAll("\\s", "");
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;,:]");
    }

    public boolean isDeprecatedValueTrue() {
        return "true".equalsIgnoreCase(this.childElementNameList);
    }

    public boolean isDeprecatedValueFalse() {
        return "false".equalsIgnoreCase(this.childElementNameList);
    }

    public boolean isNoSorting() {
        return this.getChildElementNames().isEmpty();
    }

    public String toString() {
        return "DependencySortOrder{childElementNames=" + this.getChildElementNames() + '}';
    }
}

