/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter.output;

import io.github.tonycody.maven.plugin.sorter.content.NewlineText;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import org.dom4j.Attribute;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultText;

class PatchedXMLWriter
extends XMLWriter {
    private final OutputFormat format;
    private final boolean indentBlankLines;
    private final boolean indentSchemaLocation;
    private final boolean spaceBeforeCloseEmptyElement;

    public PatchedXMLWriter(Writer writer, OutputFormat format, boolean spaceBeforeCloseEmptyElement, boolean indentBlankLines, boolean indentSchemaLocation) {
        super(writer, format);
        this.format = format;
        this.indentBlankLines = indentBlankLines;
        this.indentSchemaLocation = indentSchemaLocation;
        this.spaceBeforeCloseEmptyElement = spaceBeforeCloseEmptyElement;
    }

    protected void writeEmptyElementClose(String qualifiedName) throws IOException {
        if (!this.format.isExpandEmptyElements() && this.spaceBeforeCloseEmptyElement) {
            this.writer.write(32);
        }
        super.writeEmptyElementClose(qualifiedName);
    }

    protected void writeProcessingInstruction(ProcessingInstruction pi) throws IOException {
        this.writePrintln();
        this.indent();
        this.writer.write("<?");
        this.writer.write(pi.getName());
        this.writer.write(" ");
        this.writer.write(pi.getText());
        this.writer.write("?>");
        this.lastOutputNodeType = 7;
    }

    protected void writeNodeText(Node node) throws IOException {
        if (node instanceof NewlineText) {
            this.writePrintln();
            if (this.indentBlankLines) {
                this.indent();
            }
        } else if (this.isElementSpacePreserved(node.getParent())) {
            super.writeNodeText(node);
        } else {
            this.writeTrimmedText(node);
        }
    }

    private void writeTrimmedText(Node node) throws IOException {
        Optional<String> text = Optional.ofNullable(node.getText()).map(String::trim).filter(s -> !s.isEmpty());
        if (text.isPresent()) {
            if (node.getParent().content().size() > 1) {
                this.writePrintln();
                this.indent();
            }
            super.write((Text)new DefaultText(text.orElseThrow(IOException::new)));
        }
    }

    protected void writeAttribute(Attribute attribute) throws IOException {
        String qualifiedName = attribute.getQualifiedName();
        if (this.indentSchemaLocation && "xsi:schemaLocation".equals(qualifiedName)) {
            this.writePrintln();
            this.writeString(this.format.getIndent());
            this.writeString(this.format.getIndent());
        }
        this.writer.write(" ");
        this.writer.write(qualifiedName);
        this.writer.write("=");
        char quote = this.format.getAttributeQuoteCharacter();
        this.writer.write(quote);
        this.writeEscapeAttributeEntities(attribute.getValue());
        this.writer.write(quote);
        this.lastOutputNodeType = 2;
    }
}

