/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter;

import io.github.tonycody.maven.plugin.sorter.util.XmlOrderedResult;
import io.github.tonycody.maven.plugin.sorter.verify.ElementComparator;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.HierarchyRootWrapper;
import io.github.tonycody.maven.plugin.sorter.wrapper.operation.WrapperFactory;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class XmlProcessor {
    public static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private final WrapperFactory factory;
    private Document originalDocument;
    private Document newDocument;

    public XmlProcessor(WrapperFactory factory) {
        this.factory = factory;
    }

    public void setOriginalXml(InputStream originalXml) throws DocumentException, SAXException {
        SAXReader parser = new SAXReader();
        parser.setFeature(DISALLOW_DOCTYPE_DECL, true);
        parser.setMergeAdjacentText(true);
        this.originalDocument = parser.read(originalXml);
    }

    public void sortXml() {
        this.newDocument = (Document)this.originalDocument.clone();
        Element rootElement = this.originalDocument.getRootElement().createCopy();
        HierarchyRootWrapper rootWrapper = this.factory.createFromRootElement(rootElement);
        rootWrapper.createWrappedStructure(this.factory);
        rootWrapper.detachStructure();
        rootWrapper.sortStructureAttributes();
        rootWrapper.sortStructureElements();
        rootWrapper.connectXmlStructure();
        this.replaceRootElementInNewDocument(rootWrapper.getElementContent().getContent());
    }

    private void replaceRootElementInNewDocument(Element newElement) {
        Element rootElement = this.newDocument.getRootElement();
        List content = this.newDocument.content();
        this.newDocument.clearContent();
        for (Node node : content) {
            if (node == rootElement) {
                this.newDocument.add(newElement);
                continue;
            }
            this.newDocument.add(node);
        }
    }

    public Document getNewDocument() {
        return this.newDocument;
    }

    public XmlOrderedResult isXmlOrdered() {
        ElementComparator elementComparator = new ElementComparator(this.originalDocument.getRootElement(), this.newDocument.getRootElement());
        return elementComparator.isElementOrdered();
    }
}

