/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter;

import io.github.tonycody.maven.plugin.sorter.Sorter;
import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import io.github.tonycody.maven.plugin.sorter.logger.SorterLogger;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.parameter.VerifyFailOnType;
import io.github.tonycody.maven.plugin.sorter.parameter.VerifyFailType;
import io.github.tonycody.maven.plugin.sorter.util.XmlOrderedResult;
import java.io.File;

public class SorterHandler {
    private static final String TEXT_FILE_NOT_SORTED = "The file %s is not sorted";
    private final Sorter sorter = new Sorter();
    private SorterLogger log;
    private File pomFile;
    private VerifyFailType verifyFailType;
    private VerifyFailOnType verifyFailOn;

    public static SorterHandler getInstance() {
        return new SorterHandler();
    }

    public void initialize(SorterLogger log, PluginParameters pluginParameters) {
        this.log = log;
        this.pomFile = pluginParameters.originalPom;
        this.verifyFailType = pluginParameters.verifyFailType;
        this.verifyFailOn = pluginParameters.verifyFailOn;
        this.sorter.initialize(log, pluginParameters);
        this.warnAboutDeprecatedArguments(pluginParameters);
    }

    private void warnAboutDeprecatedArguments(PluginParameters pluginParameters) {
        if (pluginParameters.sortDependencies.isDeprecatedValueTrue()) {
            throw new FailureException("The 'true' value in sortDependencies is not supported anymore, please use value 'groupId,artifactId' instead.");
        }
        if (pluginParameters.sortDependencies.isDeprecatedValueFalse()) {
            throw new FailureException("The 'false' value in sortDependencies is not supported anymore, please use empty value '' or omit sortDependencies instead.");
        }
        if (pluginParameters.sortDependencyExclusions.isDeprecatedValueTrue()) {
            throw new FailureException("The 'true' value in sortDependencyExclusions is not supported, please use value 'groupId,artifactId' instead.");
        }
        if (pluginParameters.sortDependencyExclusions.isDeprecatedValueFalse()) {
            throw new FailureException("The 'false' value in sortDependencyExclusions is not supported, please use empty value '' or omit sortDependencyExclusions instead.");
        }
        if (pluginParameters.sortPlugins.isDeprecatedValueTrue()) {
            throw new FailureException("The 'true' value in sortPlugins is not supported anymore, please use value 'groupId,artifactId' instead.");
        }
        if (pluginParameters.sortPlugins.isDeprecatedValueFalse()) {
            throw new FailureException("The 'false' value in sortPlugins is not supported anymore, please use empty value '' or omit sortPlugins instead.");
        }
    }

    public void sort() {
        this.log.info("Sorting file " + this.pomFile.getAbsolutePath());
        this.sorter.sortOriginalXml();
        this.sorter.generateSortedXml();
        if (this.sorter.isOriginalXmlStringSorted().isOrdered()) {
            this.log.info("Pom file is already sorted, exiting");
            return;
        }
        this.sorter.createBackupFile();
        this.sorter.saveGeneratedXml();
        this.log.info("Saved sorted pom file to " + this.pomFile.getAbsolutePath());
    }

    public void check() {
        XmlOrderedResult xmlOrderedResult = this.getVerificationResult();
        this.performVerificationResult(xmlOrderedResult);
    }

    public void cleanup() {
        this.sorter.cleanup();
    }

    private XmlOrderedResult getVerificationResult() {
        XmlOrderedResult xmlOrderedResult;
        this.log.info("Verifying file " + this.pomFile.getAbsolutePath());
        this.sorter.sortOriginalXml();
        if (this.verifyFailOn == VerifyFailOnType.XMLELEMENTS) {
            xmlOrderedResult = this.sorter.isOriginalXmlElementsSorted();
        } else {
            this.sorter.generateSortedXml();
            xmlOrderedResult = this.sorter.isOriginalXmlStringSorted();
        }
        return xmlOrderedResult;
    }

    private void performVerificationResult(XmlOrderedResult xmlOrderedResult) {
        if (!xmlOrderedResult.isOrdered()) {
            switch (this.verifyFailType) {
                case WARN: {
                    this.log.warn(xmlOrderedResult.getErrorMessage());
                    this.sorter.saveViolationFile(xmlOrderedResult);
                    this.log.warn(String.format(TEXT_FILE_NOT_SORTED, this.pomFile.getAbsolutePath()));
                    break;
                }
                case SORT: {
                    this.log.info(xmlOrderedResult.getErrorMessage());
                    this.sorter.saveViolationFile(xmlOrderedResult);
                    this.log.info(String.format(TEXT_FILE_NOT_SORTED, this.pomFile.getAbsolutePath()));
                    this.log.info("Sorting file " + this.pomFile.getAbsolutePath());
                    this.sorter.generateSortedXml();
                    this.sorter.createBackupFile();
                    this.sorter.saveGeneratedXml();
                    this.log.info("Saved sorted pom file to " + this.pomFile.getAbsolutePath());
                    break;
                }
                case STOP: {
                    this.log.error(xmlOrderedResult.getErrorMessage());
                    this.sorter.saveViolationFile(xmlOrderedResult);
                    this.log.error(String.format(TEXT_FILE_NOT_SORTED, this.pomFile.getAbsolutePath()));
                    throw new FailureException(String.format(TEXT_FILE_NOT_SORTED, this.pomFile.getAbsolutePath()));
                }
            }
        }
    }
}

