/*
 * Decompiled with CFR 0.152.
 */
package io.github.tonycody.maven.plugin.sorter;

import io.github.tonycody.maven.plugin.sorter.ViolationXmlProcessor;
import io.github.tonycody.maven.plugin.sorter.XmlProcessor;
import io.github.tonycody.maven.plugin.sorter.exception.FailureException;
import io.github.tonycody.maven.plugin.sorter.logger.SorterLogger;
import io.github.tonycody.maven.plugin.sorter.output.XmlOutputGenerator;
import io.github.tonycody.maven.plugin.sorter.parameter.PluginParameters;
import io.github.tonycody.maven.plugin.sorter.processinstruction.XmlProcessingInstructionParser;
import io.github.tonycody.maven.plugin.sorter.util.FileHelper;
import io.github.tonycody.maven.plugin.sorter.util.XmlOrderedResult;
import io.github.tonycody.maven.plugin.sorter.wrapper.WrapperFactoryImpl;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class Sorter {
    private final FileHelper fileUtil = new FileHelper();
    private final XmlProcessor xmlProcessor;
    private final WrapperFactoryImpl wrapperFactory = new WrapperFactoryImpl(this.fileUtil);
    private final XmlProcessingInstructionParser xmlProcessingInstructionParser;
    private final XmlOutputGenerator xmlOutputGenerator;
    private SorterLogger log;
    private File pomFile;
    private String encoding;
    private boolean ignoreLineSeparators;
    private String violationFilename;
    private boolean backup;
    private String originalXml;
    private String sortedXml;

    public Sorter() {
        this.xmlProcessor = new XmlProcessor(this.wrapperFactory);
        this.xmlProcessingInstructionParser = new XmlProcessingInstructionParser();
        this.xmlOutputGenerator = new XmlOutputGenerator();
    }

    public void initialize(SorterLogger log, PluginParameters pluginParameters) {
        this.log = log;
        this.fileUtil.setup(pluginParameters);
        this.wrapperFactory.setup(pluginParameters);
        this.xmlProcessingInstructionParser.setup(log);
        this.xmlOutputGenerator.setup(pluginParameters);
        this.pomFile = pluginParameters.originalPom;
        this.encoding = pluginParameters.encoding;
        this.ignoreLineSeparators = pluginParameters.ignoreLineSeparators;
        this.violationFilename = pluginParameters.violationFilename;
        this.backup = pluginParameters.backup;
    }

    void sortOriginalXml() {
        this.originalXml = this.fileUtil.getPomFileContent();
        this.xmlProcessingInstructionParser.scanForIgnoredSections(this.originalXml);
        String xml = this.xmlProcessingInstructionParser.replaceIgnoredSections();
        try (ByteArrayInputStream originalXmlInputStream = new ByteArrayInputStream(xml.getBytes(this.encoding));){
            this.xmlProcessor.setOriginalXml(originalXmlInputStream);
        }
        catch (IOException | DocumentException | SAXException e) {
            throw new FailureException("Could not sort " + this.pomFile.getAbsolutePath() + " content: " + xml, e);
        }
        this.xmlProcessor.sortXml();
    }

    void generateSortedXml() {
        if (this.sortedXml != null) {
            return;
        }
        this.sortedXml = this.xmlOutputGenerator.getSortedXml(this.xmlProcessor.getNewDocument());
        if (this.xmlProcessingInstructionParser.existsIgnoredSections()) {
            this.sortedXml = this.xmlProcessingInstructionParser.revertIgnoredSections(this.sortedXml);
        }
    }

    void createBackupFile() {
        if (!this.backup) {
            return;
        }
        this.fileUtil.backupFile();
        this.log.info(String.format("Saved backup of %s to %s", this.pomFile.getAbsolutePath(), this.pomFile.getAbsolutePath()));
    }

    void saveGeneratedXml() {
        this.fileUtil.savePomFile(this.sortedXml);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    XmlOrderedResult isOriginalXmlStringSorted() {
        try (BufferedReader originalXmlReader = new BufferedReader(new StringReader(this.originalXml));
             BufferedReader sortedXmlReader = new BufferedReader(new StringReader(this.sortedXml));){
            String originalXmlLine = originalXmlReader.readLine();
            String sortedXmlLine = sortedXmlReader.readLine();
            int line = 1;
            while (originalXmlLine != null && sortedXmlLine != null) {
                if (!originalXmlLine.equals(sortedXmlLine)) {
                    XmlOrderedResult xmlOrderedResult = XmlOrderedResult.lineDiffers(line, "'" + sortedXmlLine + "'");
                    return xmlOrderedResult;
                }
                ++line;
                originalXmlLine = originalXmlReader.readLine();
                sortedXmlLine = sortedXmlReader.readLine();
            }
            if (originalXmlLine != null || sortedXmlLine != null) {
                XmlOrderedResult xmlOrderedResult = XmlOrderedResult.lineDiffers(line, sortedXmlLine == null ? "empty" : "'" + sortedXmlLine + "'");
                return xmlOrderedResult;
            }
        }
        catch (IOException ioex) {
            throw new FailureException(ioex.getMessage(), ioex);
        }
        if (this.ignoreLineSeparators) return XmlOrderedResult.ordered();
        if (!this.originalXml.equals(this.sortedXml)) return XmlOrderedResult.lineSeparatorCharactersDiffer();
        return XmlOrderedResult.ordered();
    }

    XmlOrderedResult isOriginalXmlElementsSorted() {
        return this.xmlProcessor.isXmlOrdered();
    }

    void saveViolationFile(XmlOrderedResult xmlOrderedResult) {
        if (this.violationFilename != null) {
            this.log.info("Saving violation report to " + new File(this.violationFilename).getAbsolutePath());
            ViolationXmlProcessor violationXmlProcessor = new ViolationXmlProcessor();
            Document document = violationXmlProcessor.createViolationXmlContent(this.pomFile, xmlOrderedResult.getErrorMessage());
            String violationXmlString = this.xmlOutputGenerator.getSortedXml(document);
            this.fileUtil.saveViolationFile(violationXmlString);
        }
    }

    void cleanup() {
        this.fileUtil.cleanup().ifPresent(file -> this.log.info("Deleted " + file));
    }
}

