/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.utils;

import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;

public class MarkupDocBuilderUtils {
    public static MarkupDocBuilder copyMarkupDocBuilder(MarkupDocBuilder markupDocBuilder) {
        return markupDocBuilder.copy(false);
    }

    public static String literalText(MarkupDocBuilder markupDocBuilder, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder).literalText(MarkupDocBuilderUtils.escapeText(text)).toString();
    }

    private static String escapeText(String text) {
        if (text.startsWith("*")) {
            text = "\\" + text;
        }
        return text;
    }

    public static String boldText(MarkupDocBuilder markupDocBuilder, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder).boldText(MarkupDocBuilderUtils.escapeText(text)).toString();
    }

    public static String italicText(MarkupDocBuilder markupDocBuilder, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return "";
        }
        return MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder).italicText(MarkupDocBuilderUtils.escapeText(text)).toString();
    }

    public static String crossReference(MarkupDocBuilder markupDocBuilder, String document, String anchor, String text) {
        return MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder).crossReference(document, anchor, text).toString();
    }

    public static String markupDescription(MarkupLanguage swaggerMarkupLanguage, MarkupDocBuilder markupDocBuilder, String markupText) {
        if (StringUtils.isBlank((CharSequence)markupText)) {
            return "";
        }
        return MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder).importMarkup((Reader)new StringReader(markupText), swaggerMarkupLanguage).toString().trim();
    }
}

