/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.internal.component;

import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.StringColumn;
import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.internal.adapter.PropertyAdapter;
import io.github.swagger2markup.internal.component.TableComponent;
import io.github.swagger2markup.internal.resolver.DocumentResolver;
import io.github.swagger2markup.internal.type.BasicType;
import io.github.swagger2markup.internal.type.ObjectType;
import io.github.swagger2markup.internal.type.Type;
import io.github.swagger2markup.internal.utils.InlineSchemaUtils;
import io.github.swagger2markup.internal.utils.MarkupDocBuilderUtils;
import io.github.swagger2markup.internal.utils.ModelUtils;
import io.github.swagger2markup.markup.builder.MarkupDocBuilder;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.MarkupComponent;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.swagger.models.Model;
import io.swagger.models.Response;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class ResponseComponent
extends MarkupComponent<Parameters> {
    private final TableComponent tableComponent;
    private final Map<String, Model> definitions;
    private final DocumentResolver definitionDocumentResolver;

    ResponseComponent(Swagger2MarkupConverter.Context context, DocumentResolver definitionDocumentResolver) {
        super(context);
        this.definitions = context.getSwagger().getDefinitions();
        this.definitionDocumentResolver = (DocumentResolver)Validate.notNull((Object)definitionDocumentResolver, (String)"DocumentResolver must not be null", (Object[])new Object[0]);
        this.tableComponent = new TableComponent(context);
    }

    public static Parameters parameters(PathOperation operation, int titleLevel, List<ObjectType> inlineDefinitions) {
        return new Parameters(operation, titleLevel, inlineDefinitions);
    }

    public MarkupDocBuilder apply(MarkupDocBuilder markupDocBuilder, Parameters params) {
        PathOperation operation = params.operation;
        Map responses = operation.getOperation().getResponses();
        MarkupDocBuilder responsesBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_RESPONSES_BEGIN, responsesBuilder, operation));
        if (MapUtils.isNotEmpty((Map)responses)) {
            StringColumn.Builder httpCodeColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("http_code_column"))).putMetaData("widthRatio", "2");
            StringColumn.Builder descriptionColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("description_column"))).putMetaData("widthRatio", "14").putMetaData("headerColumn", "true");
            StringColumn.Builder schemaColumnBuilder = StringColumn.builder((ColumnIds.StringColumnId)ColumnIds.StringColumnId.of((String)this.labels.getLabel("schema_column"))).putMetaData("widthRatio", "4").putMetaData("headerColumn", "true");
            Map<String, Response> sortedResponses = io.github.swagger2markup.internal.utils.MapUtils.toSortedMap(responses, this.config.getResponseOrdering());
            sortedResponses.forEach((responseName, response) -> {
                String schemaContent = this.labels.getLabel("no_content");
                if (response.getResponseSchema() != null) {
                    Model model = response.getResponseSchema();
                    Type type = null;
                    type = model != null ? ModelUtils.getType(model, this.definitions, this.definitionDocumentResolver) : new BasicType("string", (String)responseName);
                    if (this.config.isInlineSchemaEnabled()) {
                        type = InlineSchemaUtils.createInlineType(type, this.labels.getLabel("response") + " " + responseName, operation.getId() + " " + this.labels.getLabel("response") + " " + responseName, params.inlineDefinitions);
                    }
                    schemaContent = type.displaySchema(markupDocBuilder);
                }
                MarkupDocBuilder descriptionBuilder = MarkupDocBuilderUtils.copyMarkupDocBuilder(markupDocBuilder);
                descriptionBuilder.text(MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, response.getDescription()));
                Map headers = response.getHeaders();
                if (MapUtils.isNotEmpty((Map)headers)) {
                    descriptionBuilder.newLine(true).boldText(this.labels.getLabel("headers_column")).text(" : ");
                    for (Map.Entry header : headers.entrySet()) {
                        descriptionBuilder.newLine(true);
                        Property headerProperty = (Property)header.getValue();
                        PropertyAdapter headerPropertyAdapter = new PropertyAdapter(headerProperty);
                        Type propertyType = headerPropertyAdapter.getType(this.definitionDocumentResolver);
                        String headerDescription = MarkupDocBuilderUtils.markupDescription(this.config.getSwaggerMarkupLanguage(), markupDocBuilder, headerProperty.getDescription());
                        Optional<Object> optionalDefaultValue = headerPropertyAdapter.getDefaultValue();
                        descriptionBuilder.literalText((String)header.getKey()).text(String.format(" (%s)", propertyType.displaySchema(markupDocBuilder)));
                        if (!StringUtils.isNotBlank((CharSequence)headerDescription) && !optionalDefaultValue.isPresent()) continue;
                        descriptionBuilder.text(" : ");
                        if (StringUtils.isNotBlank((CharSequence)headerDescription) && !headerDescription.endsWith(".")) {
                            headerDescription = headerDescription + ".";
                        }
                        descriptionBuilder.text(headerDescription);
                        optionalDefaultValue.ifPresent(o -> descriptionBuilder.text(" ").boldText(this.labels.getLabel("default_column")).text(" : ").literalText(Json.pretty((Object)o)));
                    }
                }
                httpCodeColumnBuilder.add(MarkupDocBuilderUtils.boldText(markupDocBuilder, responseName));
                descriptionColumnBuilder.add(descriptionBuilder.toString());
                schemaColumnBuilder.add(schemaContent);
            });
            responsesBuilder = this.tableComponent.apply(responsesBuilder, TableComponent.parameters(httpCodeColumnBuilder.build(), descriptionColumnBuilder.build(), schemaColumnBuilder.build()));
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_RESPONSES_END, responsesBuilder, operation));
        String responsesContent = responsesBuilder.toString();
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_RESPONSES_BEFORE, markupDocBuilder, operation));
        if (StringUtils.isNotBlank((CharSequence)responsesContent)) {
            markupDocBuilder.sectionTitleLevel(params.titleLevel, this.labels.getLabel("responses"));
            markupDocBuilder.text(responsesContent);
        }
        this.applyPathsDocumentExtension(new PathsDocumentExtension.Context(PathsDocumentExtension.Position.OPERATION_RESPONSES_AFTER, markupDocBuilder, operation));
        return markupDocBuilder;
    }

    private void applyPathsDocumentExtension(PathsDocumentExtension.Context context) {
        this.extensionRegistry.getPathsDocumentExtensions().forEach(extension -> extension.apply(context));
    }

    public static class Parameters {
        private final PathOperation operation;
        private final int titleLevel;
        private final List<ObjectType> inlineDefinitions;

        public Parameters(PathOperation operation, int titleLevel, List<ObjectType> inlineDefinitions) {
            this.operation = (PathOperation)Validate.notNull((Object)operation, (String)"PathOperation must not be null", (Object[])new Object[0]);
            this.titleLevel = titleLevel;
            this.inlineDefinitions = (List)Validate.notNull(inlineDefinitions, (String)"InlineDefinitions must not be null", (Object[])new Object[0]);
        }
    }
}

