/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.micrometer;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.functions.CheckedConsumer;
import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.core.functions.CheckedRunnable;
import io.github.resilience4j.core.functions.CheckedSupplier;
import io.github.resilience4j.micrometer.TimerConfig;
import io.github.resilience4j.micrometer.event.TimerEvent;
import io.github.resilience4j.micrometer.event.TimerOnFailureEvent;
import io.github.resilience4j.micrometer.event.TimerOnStartEvent;
import io.github.resilience4j.micrometer.event.TimerOnSuccessEvent;
import io.github.resilience4j.micrometer.internal.TimerImpl;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Timer {
    public static Timer of(String name, MeterRegistry registry) {
        return Timer.of(name, registry, TimerConfig.ofDefaults(), Collections.emptyMap());
    }

    public static Timer of(String name, MeterRegistry registry, TimerConfig timerConfig) {
        return Timer.of(name, registry, timerConfig, Collections.emptyMap());
    }

    public static Timer of(String name, MeterRegistry registry, TimerConfig timerConfig, Map<String, String> tags) {
        return new TimerImpl(name, registry, timerConfig, tags);
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(Timer timer, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            Context context = timer.createContext();
            try {
                ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                    if (throwable != null) {
                        context.onFailure((Throwable)throwable);
                        promise.completeExceptionally((Throwable)throwable);
                    } else {
                        context.onSuccess();
                        promise.complete(result);
                    }
                });
            }
            catch (Exception e) {
                context.onFailure(e);
                promise.completeExceptionally(e);
            }
            return promise;
        };
    }

    public static <T> CheckedSupplier<T> decorateCheckedSupplier(Timer timer, CheckedSupplier<T> supplier) {
        return () -> {
            Context context = timer.createContext();
            try {
                Object result = supplier.get();
                context.onSuccess();
                return result;
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Timer timer, CheckedRunnable runnable) {
        return () -> {
            Context context = timer.createContext();
            try {
                runnable.run();
                context.onSuccess();
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static <T, R> CheckedFunction<T, R> decorateCheckedFunction(Timer timer, CheckedFunction<T, R> function) {
        return input -> {
            Context context = timer.createContext();
            try {
                Object result = function.apply(input);
                context.onSuccess();
                return result;
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Timer timer, Supplier<T> supplier) {
        return () -> {
            Context context = timer.createContext();
            try {
                Object result = supplier.get();
                context.onSuccess();
                return result;
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Timer timer, Callable<T> callable) {
        return () -> {
            Context context = timer.createContext();
            try {
                Object result = callable.call();
                context.onSuccess();
                return result;
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static Runnable decorateRunnable(Timer timer, Runnable runnable) {
        return () -> {
            Context context = timer.createContext();
            try {
                runnable.run();
                context.onSuccess();
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Timer timer, Function<T, R> function) {
        return input -> {
            Context context = timer.createContext();
            try {
                Object result = function.apply(input);
                context.onSuccess();
                return result;
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static <T> Consumer<T> decorateConsumer(Timer timer, Consumer<T> consumer) {
        return input -> {
            Context context = timer.createContext();
            try {
                consumer.accept(input);
                context.onSuccess();
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(Timer timer, CheckedConsumer<T> consumer) {
        return input -> {
            Context context = timer.createContext();
            try {
                consumer.accept(input);
                context.onSuccess();
            }
            catch (Exception e) {
                context.onFailure(e);
                throw e;
            }
        };
    }

    public String getName();

    public TimerConfig getTimerConfig();

    public Map<String, String> getTags();

    default public <T> T executeCheckedSupplier(CheckedSupplier<T> checkedSupplier) throws Throwable {
        return (T)Timer.decorateCheckedSupplier(this, checkedSupplier).get();
    }

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Timer.decorateSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Timer.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Timer.decorateRunnable(this, runnable).run();
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return Timer.decorateCompletionStage(this, supplier).get();
    }

    public Context createContext();

    public EventPublisher getEventPublisher();

    public static interface Context {
        public void onSuccess();

        public void onFailure(Throwable var1);
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<TimerEvent> {
        public EventPublisher onStart(EventConsumer<TimerOnStartEvent> var1);

        public EventPublisher onSuccess(EventConsumer<TimerOnSuccessEvent> var1);

        public EventPublisher onFailure(EventConsumer<TimerOnFailureEvent> var1);
    }
}

