/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service;

import io.fabric8.maven.docker.access.AuthConfig;
import io.fabric8.maven.docker.access.DockerAccess;
import io.fabric8.maven.docker.assembly.BuildDirs;
import io.fabric8.maven.docker.assembly.DockerAssemblyManager;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.config.BuildXConfiguration;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.util.EnvUtil;
import io.fabric8.maven.docker.util.ImageName;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.maven.docker.util.ProjectPaths;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.maven.plugin.MojoExecutionException;

public class BuildXService {
    private final DockerAccess dockerAccess;
    private final DockerAssemblyManager dockerAssemblyManager;
    private final Logger logger;
    private final Exec exec;

    public BuildXService(DockerAccess dockerAccess, DockerAssemblyManager dockerAssemblyManager, Logger logger) {
        this(dockerAccess, dockerAssemblyManager, logger, new DefaultExec(logger));
    }

    public BuildXService(DockerAccess dockerAccess, DockerAssemblyManager dockerAssemblyManager, Logger logger, Exec exec) {
        this.dockerAccess = dockerAccess;
        this.dockerAssemblyManager = dockerAssemblyManager;
        this.logger = logger;
        this.exec = exec;
    }

    public void build(ProjectPaths projectPaths, ImageConfiguration imageConfig, String configuredRegistry, AuthConfig authConfig, File buildArchive) throws MojoExecutionException {
        this.useBuilder(projectPaths, imageConfig, configuredRegistry, authConfig, buildArchive, this::buildAndLoadNativePlatform);
    }

    public void push(ProjectPaths projectPaths, ImageConfiguration imageConfig, String configuredRegistry, AuthConfig authConfig) throws MojoExecutionException {
        BuildDirs buildDirs = new BuildDirs(projectPaths, imageConfig.getName());
        File archive = new File(buildDirs.getTemporaryRootDirectory(), "docker-build.tar");
        this.useBuilder(projectPaths, imageConfig, configuredRegistry, authConfig, archive, this::pushMultiPlatform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C> void useBuilder(ProjectPaths projectPaths, ImageConfiguration imageConfig, String configuredRegistry, AuthConfig authConfig, C context, Builder<C> builder) throws MojoExecutionException {
        BuildDirs buildDirs = new BuildDirs(projectPaths, imageConfig.getName());
        Path configPath = this.getDockerStateDir(imageConfig.getBuildConfiguration(), buildDirs);
        List<String> buildX = Arrays.asList("docker", "--config", configPath.toString(), "buildx");
        String builderName = this.createBuilder(configPath, buildX, imageConfig, buildDirs);
        Path configJson = configPath.resolve("config.json");
        try {
            this.createConfigJson(configJson, authConfig);
            builder.useBuilder(buildX, builderName, buildDirs, imageConfig, configuredRegistry, context);
        }
        finally {
            this.removeConfigJson(configJson);
        }
    }

    private void createConfigJson(Path configJson, AuthConfig authConfig) throws MojoExecutionException {
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(configJson, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            bufferedWriter.write(authConfig != null ? authConfig.toJson() : "{}");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create config.json", (Exception)e);
        }
    }

    private void removeConfigJson(Path configJson) {
        try {
            Files.deleteIfExists(configJson);
        }
        catch (IOException e) {
            this.logger.warn("Unable to delete %s", configJson);
        }
    }

    private void buildAndLoadNativePlatform(List<String> buildX, String builderName, BuildDirs buildDirs, ImageConfiguration imageConfig, String configuredRegistry, File buildArchive) throws MojoExecutionException {
        String nativePlatform;
        List<String> platforms = imageConfig.getBuildConfiguration().getBuildX().getPlatforms();
        if (platforms.contains(nativePlatform = this.dockerAccess.getNativePlatform())) {
            this.buildX(buildX, builderName, buildDirs, imageConfig, configuredRegistry, Collections.singletonList(nativePlatform), buildArchive, "--load");
        } else {
            this.logger.info("Native platform not specified, no image built", new Object[0]);
        }
    }

    private void pushMultiPlatform(List<String> buildX, String builderName, BuildDirs buildDirs, ImageConfiguration imageConfig, String configuredRegistry, File buildArchive) throws MojoExecutionException {
        this.buildX(buildX, builderName, buildDirs, imageConfig, configuredRegistry, imageConfig.getBuildConfiguration().getBuildX().getPlatforms(), buildArchive, "--push");
    }

    private void buildX(List<String> buildX, String builderName, BuildDirs buildDirs, ImageConfiguration imageConfig, String configuredRegistry, List<String> platforms, File buildArchive, String extraParam) throws MojoExecutionException {
        String[] ctxCmds;
        File contextDir;
        BuildImageConfiguration buildConfiguration = imageConfig.getBuildConfiguration();
        ArrayList<String> cmdLine = new ArrayList<String>(buildX);
        cmdLine.add("build");
        cmdLine.add("--progress=plain");
        cmdLine.add("--builder");
        cmdLine.add(builderName);
        cmdLine.add("--platform");
        cmdLine.add(String.join((CharSequence)",", platforms));
        buildConfiguration.getTags().forEach(t -> {
            cmdLine.add("--tag");
            cmdLine.add(new ImageName(imageConfig.getName(), (String)t).getFullName(configuredRegistry));
        });
        cmdLine.add("--tag");
        cmdLine.add(new ImageName(imageConfig.getName()).getFullName(configuredRegistry));
        Map<String, String> args = buildConfiguration.getArgs();
        if (args != null) {
            args.forEach((key, value) -> {
                cmdLine.add("--build-arg");
                cmdLine.add(key + '=' + value);
            });
        }
        if (buildConfiguration.squash()) {
            cmdLine.add("--squash");
        }
        if (extraParam != null) {
            cmdLine.add(extraParam);
        }
        if ((contextDir = buildConfiguration.getContextDir()) != null) {
            Path destinationPath = this.getContextPath(buildArchive);
            Path dockerFileRelativePath = contextDir.toPath().relativize(buildConfiguration.getDockerFile().toPath());
            ctxCmds = new String[]{"--file=" + destinationPath.resolve(dockerFileRelativePath), destinationPath.toString()};
        } else {
            ctxCmds = new String[]{buildDirs.getOutputDirectory().getAbsolutePath()};
        }
        int rc = this.exec.process(cmdLine, ctxCmds);
        if (rc != 0) {
            throw new MojoExecutionException("Error status (" + rc + ") when building");
        }
    }

    private Path getContextPath(File buildArchive) throws MojoExecutionException {
        String archiveName = buildArchive.getName();
        String fileName = archiveName.substring(0, archiveName.indexOf(46));
        File destinationDirectory = new File(buildArchive.getParentFile(), fileName);
        Path destinationPath = destinationDirectory.toPath();
        try {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        this.dockerAssemblyManager.extractDockerTarArchive(buildArchive, destinationDirectory);
        return destinationPath;
    }

    private Path getDockerStateDir(BuildImageConfiguration buildConfiguration, BuildDirs buildDirs) {
        String stateDir = buildConfiguration.getBuildX().getDockerStateDir();
        Path dockerStatePath = buildDirs.getBuildPath(stateDir != null ? EnvUtil.resolveHomeReference(stateDir) : "docker");
        this.createDirectory(dockerStatePath);
        return dockerStatePath;
    }

    private void createDirectory(Path cachePath) {
        try {
            Files.createDirectories(cachePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot create " + cachePath);
        }
    }

    private String createBuilder(Path configPath, List<String> buildX, ImageConfiguration imageConfig, BuildDirs buildDirs) throws MojoExecutionException {
        Path builderPath;
        BuildXConfiguration buildXConfiguration = imageConfig.getBuildConfiguration().getBuildX();
        String builderName = buildXConfiguration.getBuilderName();
        if (builderName == null) {
            builderName = "maven";
        }
        if (Files.notExists(builderPath = configPath.resolve(Paths.get("buildx", "instances", builderName)), new LinkOption[0])) {
            String[] stringArray;
            String buildConfig = buildXConfiguration.getConfigFile();
            if (buildConfig == null) {
                String[] stringArray2 = new String[5];
                stringArray2[0] = "create";
                stringArray2[1] = "--driver";
                stringArray2[2] = "docker-container";
                stringArray2[3] = "--name";
                stringArray = stringArray2;
                stringArray2[4] = builderName;
            } else {
                String[] stringArray3 = new String[7];
                stringArray3[0] = "create";
                stringArray3[1] = "--driver";
                stringArray3[2] = "docker-container";
                stringArray3[3] = "--name";
                stringArray3[4] = builderName;
                stringArray3[5] = "--config";
                stringArray = stringArray3;
                stringArray3[6] = buildDirs.getProjectPath(EnvUtil.resolveHomeReference(buildConfig)).toString();
            }
            int rc = this.exec.process(buildX, stringArray);
            if (rc != 0) {
                throw new MojoExecutionException("Error status (" + rc + ") while creating builder " + builderName);
            }
        }
        return builderName;
    }

    public static class DefaultExec
    implements Exec {
        private final Logger logger;

        public DefaultExec(Logger logger) {
            this.logger = logger;
        }

        @Override
        public int process(List<String> buildX, String ... cmd) throws MojoExecutionException {
            List<String> cmdLine;
            if (cmd.length > 0) {
                cmdLine = new ArrayList<String>(buildX);
                cmdLine.addAll(Arrays.asList(cmd));
            } else {
                cmdLine = buildX;
            }
            try {
                this.logger.info(String.join((CharSequence)" ", cmdLine), new Object[0]);
                ProcessBuilder builder = new ProcessBuilder(cmdLine);
                Process process = builder.start();
                this.pumpStream(process.getInputStream());
                this.pumpStream(process.getErrorStream());
                return process.waitFor();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new MojoExecutionException("Interrupted while executing " + cmdLine, (Exception)ex);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("unable to execute " + cmdLine, (Exception)ex);
            }
        }

        private void pumpStream(InputStream is) {
            CompletableFuture.runAsync(() -> {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
                    bufferedReader.lines().forEach(x$0 -> this.logger.info((String)x$0, new Object[0]));
                }
                catch (IOException e) {
                    this.logger.error("failed redirecting stream %s", e.getMessage());
                }
            });
        }
    }

    public static interface Exec {
        public int process(List<String> var1, String ... var2) throws MojoExecutionException;
    }

    static interface Builder<C> {
        public void useBuilder(List<String> var1, String var2, BuildDirs var3, ImageConfiguration var4, String var5, C var6) throws MojoExecutionException;
    }
}

