/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.variables.AbstractDistributedValue;

public class ValueCommands {
    private ValueCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        @Override
        public void resolve(SerializerRegistry registry) {
            registry.register(CompareAndSet.class, -110);
            registry.register(Get.class, -111);
            registry.register(GetAndSet.class, -112);
            registry.register(Set.class, -113);
            registry.register(AbstractDistributedValue.ChangeEvent.class, -120);
            registry.register(Register.class, -121);
            registry.register(Unregister.class, -122);
        }
    }

    public static class Unregister
    extends ValueCommand<Void> {
    }

    public static class Register
    extends ValueCommand<Void> {
    }

    public static class GetAndSet<T>
    extends ValueCommand<T> {
        private T value;

        public GetAndSet() {
        }

        public GetAndSet(T value) {
            this.value = value;
        }

        public GetAndSet(T value, long ttl) {
            super(ttl);
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }

        public String toString() {
            return String.format("%s[value=%s]", this.getClass().getSimpleName(), this.value);
        }
    }

    public static class CompareAndSet<T>
    extends ValueCommand<Boolean> {
        private T expect;
        private T update;

        public CompareAndSet() {
        }

        public CompareAndSet(T expect, T update) {
            this.expect = expect;
            this.update = update;
        }

        public CompareAndSet(T expect, T update, long ttl) {
            super(ttl);
            this.expect = expect;
            this.update = update;
        }

        public T expect() {
            return this.expect;
        }

        public T update() {
            return this.update;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.expect, buffer);
            serializer.writeObject(this.update, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.expect = serializer.readObject(buffer);
            this.update = serializer.readObject(buffer);
        }

        public String toString() {
            return String.format("%s[expect=%s, update=%s]", this.getClass().getSimpleName(), this.expect, this.update);
        }
    }

    public static class Set<T>
    extends ValueCommand<T> {
        private T value;

        public Set() {
        }

        public Set(T value) {
            this.value = value;
        }

        public Set(T value, long ttl) {
            super(ttl);
            this.value = value;
        }

        public T value() {
            return this.value;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            serializer.writeObject(this.value, buffer);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.value = serializer.readObject(buffer);
        }

        public String toString() {
            return String.format("%s[value=%s]", this.getClass().getSimpleName(), this.value);
        }
    }

    public static class Get<T>
    extends ValueQuery<T> {
        public Get() {
        }

        public Get(Query.ConsistencyLevel consistency) {
            super(consistency);
        }
    }

    public static abstract class ValueQuery<V>
    implements Query<V>,
    CatalystSerializable {
        private Query.ConsistencyLevel consistency;

        protected ValueQuery() {
        }

        protected ValueQuery(Query.ConsistencyLevel consistency) {
            this.consistency = consistency;
        }

        @Override
        public void writeObject(BufferOutput<?> output, Serializer serializer) {
            if (this.consistency != null) {
                output.writeByte(this.consistency.ordinal());
            } else {
                output.writeByte(-1);
            }
        }

        @Override
        public void readObject(BufferInput<?> input, Serializer serializer) {
            int ordinal = input.readByte();
            if (ordinal != -1) {
                this.consistency = Query.ConsistencyLevel.values()[ordinal];
            }
        }
    }

    public static abstract class ValueCommand<V>
    implements Command<V>,
    CatalystSerializable {
        protected long ttl;

        protected ValueCommand() {
        }

        protected ValueCommand(long ttl) {
            this.ttl = ttl;
        }

        @Override
        public Command.CompactionMode compaction() {
            return this.ttl > 0L ? Command.CompactionMode.EXPIRING : Command.CompactionMode.QUORUM;
        }

        public long ttl() {
            return this.ttl;
        }

        @Override
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
            buffer.writeLong(this.ttl);
        }

        @Override
        public void readObject(BufferInput<?> buffer, Serializer serializer) {
            this.ttl = buffer.readLong();
        }
    }
}

