/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceCopycatClient;
import io.atomix.resource.internal.ResourceEvent;
import io.atomix.resource.internal.ResourceQuery;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public abstract class AbstractResource<T extends Resource<T>>
implements Resource<T> {
    private final ResourceType type;
    protected final CopycatClient client;
    protected volatile Resource.Config config;
    protected final Resource.Options options;
    private volatile Resource.State state;
    private final Set<StateChangeListener> changeListeners = new CopyOnWriteArraySet<StateChangeListener>();
    private final Set<RecoveryListener> recoveryListeners = new CopyOnWriteArraySet<RecoveryListener>();
    private final Map<Integer, Set<Consumer>> eventListeners = new ConcurrentHashMap<Integer, Set<Consumer>>();
    private final AtomicInteger recoveryAttempt = new AtomicInteger(0);

    protected AbstractResource(CopycatClient client, Properties options) {
        this(client, null, options);
    }

    protected AbstractResource(CopycatClient client, ResourceType type, Properties options) {
        this.client = new ResourceCopycatClient(Assert.notNull(client, "client"));
        if (type == null) {
            type = new ResourceType(this.getClass());
        }
        this.type = type;
        client.serializer().register(ResourceCommand.class, -50);
        client.serializer().register(ResourceQuery.class, -51);
        client.serializer().register(ResourceQuery.Config.class, -52);
        client.serializer().register(ResourceCommand.Delete.class, -53);
        client.serializer().register(ResourceType.class, -54);
        client.serializer().register(ResourceEvent.class, -49);
        this.config = new Resource.Config();
        this.options = new Resource.Options(Assert.notNull(options, "options"));
        client.onStateChange(this::onStateChange);
    }

    protected synchronized <T extends Resource.Event> CompletableFuture<Listener<T>> onEvent(final Resource.EventType type, final Consumer<T> callback) {
        final Set listeners = this.eventListeners.computeIfAbsent(type.id(), id -> new CopyOnWriteArraySet());
        listeners.add(callback);
        return ((CompletableFuture)this.client.submit(new ResourceCommand.Register(type.id())).whenComplete((result, error) -> {
            if (error != null) {
                AbstractResource abstractResource = this;
                synchronized (abstractResource) {
                    listeners.remove(callback);
                    if (listeners.isEmpty()) {
                        this.eventListeners.remove(type.id());
                        this.client.submit(new ResourceCommand.Unregister(type.id()));
                    }
                }
            }
        })).thenApply(v -> new Listener<T>(){

            @Override
            public void accept(T event) {
                callback.accept(event);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    listeners.remove(callback);
                    if (listeners.isEmpty()) {
                        AbstractResource.this.eventListeners.remove(type.id());
                        AbstractResource.this.client.submit(new ResourceCommand.Unregister(type.id()));
                    }
                }
            }
        });
    }

    private void onEvent(ResourceEvent event) {
        Set<Consumer> listeners = this.eventListeners.get(event.id());
        if (listeners != null) {
            for (Consumer listener : listeners) {
                listener.accept(event.event());
            }
        }
    }

    private void onStateChange(CopycatClient.State state) {
        Resource.State newState = Resource.State.valueOf(state.name());
        if (this.state == Resource.State.SUSPENDED && newState == Resource.State.CONNECTED) {
            int attempt = this.recoveryAttempt.incrementAndGet();
            this.recover(attempt).whenComplete((v, e) -> this.recoveryListeners.forEach(l -> l.accept(attempt)));
        }
        this.state = newState;
        this.changeListeners.forEach(l -> l.accept(this.state));
    }

    @Override
    public ResourceType type() {
        return this.type;
    }

    @Override
    public Serializer serializer() {
        return this.client.serializer();
    }

    @Override
    public Resource.Config config() {
        return this.config;
    }

    @Override
    public Resource.Options options() {
        return this.options;
    }

    @Override
    public Resource.State state() {
        return this.state;
    }

    @Override
    public Listener<Resource.State> onStateChange(Consumer<Resource.State> callback) {
        return new StateChangeListener(Assert.notNull(callback, "callback"));
    }

    @Override
    public Listener<Integer> onRecovery(Consumer<Integer> callback) {
        return new RecoveryListener(Assert.notNull(callback, "callback"));
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public CompletableFuture<T> open() {
        return ((CompletableFuture)this.client.connect().thenCompose(v -> this.client.submit(new ResourceQuery.Config()))).thenApply(config -> {
            this.config = new Resource.Config((Properties)config);
            this.client.onEvent("event", this::onEvent);
            return this;
        });
    }

    @Override
    public boolean isOpen() {
        return this.state != Resource.State.CLOSED;
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.client.close();
    }

    @Override
    public boolean isClosed() {
        return this.state == Resource.State.CLOSED;
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.client.submit(new ResourceCommand.Delete());
    }

    public int hashCode() {
        return 851 + this.client.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractResource && ((AbstractResource)object).client.session().id() == this.client.session().id();
    }

    public String toString() {
        return String.format("%s[id=%s]", this.getClass().getSimpleName(), this.client.session().id());
    }

    protected CompletableFuture<Void> recover(Integer attempt) {
        return CompletableFuture.completedFuture(null);
    }

    private class RecoveryListener
    implements Listener<Integer> {
        private final Consumer<Integer> callback;

        private RecoveryListener(Consumer<Integer> callback) {
            this.callback = callback;
            AbstractResource.this.recoveryListeners.add(this);
        }

        @Override
        public void accept(Integer attempt) {
            this.callback.accept(attempt);
        }

        @Override
        public void close() {
            AbstractResource.this.recoveryListeners.remove(this);
        }
    }

    private class StateChangeListener
    implements Listener<Resource.State> {
        private final Consumer<Resource.State> callback;

        private StateChangeListener(Consumer<Resource.State> callback) {
            this.callback = callback;
            AbstractResource.this.changeListeners.add(this);
        }

        @Override
        public void accept(Resource.State state) {
            this.callback.accept(state);
        }

        @Override
        public void close() {
            AbstractResource.this.changeListeners.remove(this);
        }
    }
}

