/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager.internal;

import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.Snapshottable;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;
import io.atomix.manager.ResourceManagerException;
import io.atomix.manager.internal.CloseResource;
import io.atomix.manager.internal.DeleteResource;
import io.atomix.manager.internal.GetResource;
import io.atomix.manager.internal.GetResourceIfExists;
import io.atomix.manager.internal.GetResourceKeys;
import io.atomix.manager.internal.ManagedResourceSession;
import io.atomix.manager.internal.ResourceExists;
import io.atomix.manager.internal.ResourceManagerCommitPool;
import io.atomix.manager.internal.ResourceManagerStateMachineExecutor;
import io.atomix.manager.resource.internal.InstanceOperation;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ResourceManagerState
extends StateMachine
implements SessionListener,
Snapshottable {
    private StateMachineExecutor executor;
    private final Map<String, Long> keys = new HashMap<String, Long>();
    private final Map<Long, ResourceHolder> resources = new HashMap<Long, ResourceHolder>();
    private final ResourceManagerCommitPool commits = new ResourceManagerCommitPool();

    @Override
    public void configure(StateMachineExecutor executor) {
        this.executor = executor;
        executor.register(InstanceOperation.class, this::operateResource);
        executor.register(GetResource.class, this::getResource);
        executor.register(GetResourceIfExists.class, this::getResourceIfExists);
        executor.register(CloseResource.class, this::closeResource);
        executor.register(DeleteResource.class, this::deleteResource);
        executor.register(ResourceExists.class, this::resourceExists);
        executor.register(GetResourceKeys.class, this::getResourceKeys);
    }

    @Override
    public void snapshot(SnapshotWriter writer) {
        ArrayList<ResourceHolder> resources = new ArrayList<ResourceHolder>(this.resources.values());
        Collections.sort(resources, (r1, r2) -> (int)(((ResourceHolder)r1).id - ((ResourceHolder)r2).id));
        for (ResourceHolder resource : resources) {
            if (!(resource.stateMachine instanceof Snapshottable)) continue;
            ((Snapshottable)((Object)resource.stateMachine)).snapshot(writer);
        }
    }

    @Override
    public void install(SnapshotReader reader) {
        ArrayList<ResourceHolder> resources = new ArrayList<ResourceHolder>(this.resources.values());
        Collections.sort(resources, (r1, r2) -> (int)(((ResourceHolder)r1).id - ((ResourceHolder)r2).id));
        for (ResourceHolder resource : resources) {
            if (!(resource.stateMachine instanceof Snapshottable)) continue;
            ((Snapshottable)((Object)resource.stateMachine)).install(reader);
        }
    }

    private Object operateResource(Commit<InstanceOperation> commit) {
        long resourceId = commit.operation().resource();
        ResourceHolder resource = this.resources.get(resourceId);
        if (resource == null) {
            commit.close();
            throw new ResourceManagerException("unknown resource: " + resourceId, new Object[0]);
        }
        ManagedResourceSession resourceSession = ((ResourceHolder)resource).executor.context.sessions.session(commit.session().id());
        if (resourceSession == null) {
            resourceSession = new ManagedResourceSession(resourceId, commit, commit.session());
        }
        return resource.executor.execute(this.commits.acquire(commit, resourceSession));
    }

    protected long getResource(Commit<? extends GetResource> commit) {
        String key = commit.operation().key();
        ResourceType type = commit.operation().type();
        Long resourceId = this.keys.get(key);
        if (resourceId == null) {
            resourceId = commit.index();
            this.keys.put(key, resourceId);
            try {
                ResourceStateMachine stateMachine = type.factory().newInstance().createStateMachine(new Resource.Config(commit.operation().config()));
                ResourceManagerStateMachineExecutor executor = new ResourceManagerStateMachineExecutor(resourceId, this.executor);
                ResourceHolder resource = new ResourceHolder(resourceId, key, type, commit, stateMachine, executor);
                this.resources.put(resourceId, resource);
                stateMachine.init(executor);
                ManagedResourceSession resourceSession = new ManagedResourceSession(resourceId, commit, commit.session());
                ((ResourceHolder)resource).executor.context.sessions.register(resourceSession);
                return resourceId;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ResourceManagerException("failed to instantiate state machine", new Object[]{e});
            }
        }
        ResourceHolder resource = this.resources.get(resourceId);
        if (resource == null || !resource.type.equals(type)) {
            throw new ResourceManagerException("inconsistent resource type: " + commit.operation().type(), new Object[0]);
        }
        ManagedResourceSession resourceSession = new ManagedResourceSession(resourceId, commit, commit.session());
        ((ResourceHolder)resource).executor.context.sessions.register(resourceSession);
        return resourceId;
    }

    private long getResourceIfExists(Commit<GetResourceIfExists> commit) {
        String key = commit.operation().key();
        Long resourceId = this.keys.get(key);
        if (resourceId != null) {
            return this.getResource(commit);
        }
        return 0L;
    }

    protected boolean resourceExists(Commit<ResourceExists> commit) {
        try {
            boolean bl = this.keys.containsKey(commit.operation().key());
            return bl;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResource(Commit<CloseResource> commit) {
        try {
            long resourceId = commit.operation().resource();
            ResourceHolder resource = this.resources.get(resourceId);
            if (resource == null) {
                throw new ResourceManagerException("unknown resource: " + resourceId, new Object[0]);
            }
            ((ResourceHolder)resource).executor.context.sessions.unregister(commit.session().id());
            ((ResourceHolder)resource).executor.context.sessions.close(commit.session().id());
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteResource(Commit<DeleteResource> commit) {
        try {
            ResourceHolder resource = this.resources.remove(commit.operation().resource());
            if (resource == null) {
                throw new ResourceManagerException("unknown resource: " + commit.operation().resource(), new Object[0]);
            }
            resource.stateMachine.delete();
            resource.executor.close();
            resource.commit.close();
            this.keys.remove(resource.key);
            boolean bl = true;
            return bl;
        }
        finally {
            commit.close();
        }
    }

    protected Set<String> getResourceKeys(Commit<GetResourceKeys> commit) {
        try {
            if (commit.operation().type() == 0) {
                HashSet<String> hashSet = new HashSet<String>(this.keys.keySet());
                return hashSet;
            }
            HashSet<String> hashSet = new HashSet<String>(this.resources.entrySet().stream().filter(e -> ((ResourceHolder)e.getValue()).type.id() == ((GetResourceKeys)commit.operation()).type()).map(e -> ((ResourceHolder)e.getValue()).key).collect(Collectors.toSet()));
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    @Override
    public void register(ServerSession session) {
    }

    @Override
    public void expire(ServerSession session) {
        for (ResourceHolder resource : this.resources.values()) {
            ((ResourceHolder)resource).executor.context.sessions.expire(session.id());
        }
    }

    @Override
    public void unregister(ServerSession session) {
        for (ResourceHolder resource : this.resources.values()) {
            ((ResourceHolder)resource).executor.context.sessions.unregister(session.id());
        }
    }

    @Override
    public void close(ServerSession session) {
        for (ResourceHolder resource : this.resources.values()) {
            ((ResourceHolder)resource).executor.context.sessions.close(session.id());
        }
    }

    private static class ResourceHolder {
        private final long id;
        private final String key;
        private final ResourceType type;
        private final Commit<? extends GetResource> commit;
        private final ResourceStateMachine stateMachine;
        private final ResourceManagerStateMachineExecutor executor;

        private ResourceHolder(long id, String key, ResourceType type, Commit<? extends GetResource> commit, ResourceStateMachine stateMachine, ResourceManagerStateMachineExecutor executor) {
            this.id = id;
            this.key = key;
            this.type = type;
            this.commit = commit;
            this.stateMachine = stateMachine;
            this.executor = executor;
        }
    }
}

