/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.index;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.MappedBuffer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.index.OffsetIndex;

public class SequentialOffsetIndex
implements OffsetIndex {
    private static final long MAX_POSITION = (long)Math.pow(2.0, 32.0) - 1L;
    private static final int POSITION_SIZE = 4;
    private final Buffer buffer;
    private int size;
    private long lastOffset = -1L;

    public SequentialOffsetIndex(Buffer buffer) {
        this.buffer = Assert.notNull(buffer, "buffer");
    }

    @Override
    public long lastOffset() {
        return this.lastOffset;
    }

    @Override
    public boolean index(long offset, long position) {
        Assert.argNot(offset, this.lastOffset > -1L && offset <= this.lastOffset, "offset cannot be less than or equal to the last offset in the index", new Object[0]);
        Assert.argNot(position > MAX_POSITION, "position cannot be greater than " + MAX_POSITION, new Object[0]);
        if (offset > this.lastOffset + 1L) {
            return false;
        }
        if (offset == this.lastOffset + 1L) {
            this.buffer.writeUnsignedInt(position);
            ++this.size;
            this.lastOffset = offset;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(long offset) {
        return offset >= 0L && offset <= this.lastOffset;
    }

    @Override
    public long position(long offset) {
        if (offset >= 0L && offset <= this.lastOffset) {
            return this.buffer.readUnsignedInt(offset * 4L);
        }
        return -1L;
    }

    @Override
    public long find(long offset) {
        return offset;
    }

    @Override
    public long truncate(long offset) {
        if (offset == this.lastOffset) {
            return -1L;
        }
        if (offset == -1L) {
            this.buffer.position(0L).zero();
            this.lastOffset = -1L;
            this.size = 0;
            return 0L;
        }
        this.buffer.position(offset * 4L + 4L);
        this.lastOffset = offset;
        this.size = (int)(this.lastOffset + 1L);
        return this.buffer.readUnsignedInt(offset * 4L + 4L);
    }

    @Override
    public void flush() {
        this.buffer.flush();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    @Override
    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        } else if (this.buffer instanceof MappedBuffer) {
            ((MappedBuffer)this.buffer).delete();
        }
    }
}

