/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.ActiveState;
import io.atomix.copycat.server.state.MemberState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerMember;
import io.atomix.copycat.server.state.ServerState;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.util.Quorum;
import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

final class CandidateState
extends ActiveState {
    private final Random random = new Random();
    private Quorum quorum;
    private Scheduled currentTimer;

    public CandidateState(ServerContext context) {
        super(context);
    }

    @Override
    public CopycatServer.State type() {
        return CopycatServer.State.CANDIDATE;
    }

    @Override
    public synchronized CompletableFuture<ServerState> open() {
        return ((CompletableFuture)super.open().thenRun(this::startElection)).thenApply(v -> this);
    }

    void startElection() {
        this.LOGGER.info("{} - Starting election", (Object)this.context.getCluster().member().address());
        this.sendVoteRequests();
    }

    private void sendVoteRequests() {
        long lastTerm;
        Entry lastEntry;
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
        }
        this.context.setTerm(this.context.getTerm() + 1L).setLastVotedFor(this.context.getCluster().member().id());
        Duration delay = this.context.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.context.getElectionTimeout().toMillis())));
        this.currentTimer = this.context.getThreadContext().schedule(delay, () -> {
            this.LOGGER.debug("{} - Election timed out", (Object)this.context.getCluster().member().address());
            if (this.quorum != null) {
                this.quorum.cancel();
                this.quorum = null;
            }
            this.sendVoteRequests();
            this.LOGGER.debug("{} - Restarted election", (Object)this.context.getCluster().member().address());
        });
        AtomicBoolean complete = new AtomicBoolean();
        HashSet votingMembers = new HashSet(this.context.getClusterState().getActiveMemberStates().stream().map(MemberState::getMember).collect(Collectors.toList()));
        if (votingMembers.isEmpty()) {
            this.LOGGER.trace("{} - Single member cluster. Transitioning directly to leader.", (Object)this.context.getCluster().member().address());
            this.context.transition(CopycatServer.State.LEADER);
            return;
        }
        Quorum quorum = new Quorum(this.context.getClusterState().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.context.transition(CopycatServer.State.LEADER);
            } else {
                this.context.transition(CopycatServer.State.FOLLOWER);
            }
        });
        long lastIndex = this.context.getLog().lastIndex();
        Entry entry = lastEntry = lastIndex != 0L ? (Entry)this.context.getLog().get(lastIndex) : null;
        if (lastEntry != null) {
            lastTerm = lastEntry.getTerm();
            lastEntry.close();
        } else {
            lastTerm = 0L;
        }
        this.LOGGER.debug("{} - Requesting votes for term {}", (Object)this.context.getCluster().member().address(), (Object)this.context.getTerm());
        for (ServerMember member : votingMembers) {
            this.LOGGER.debug("{} - Requesting vote from {} for term {}", new Object[]{this.context.getCluster().member().address(), member, this.context.getTerm()});
            VoteRequest request = VoteRequest.builder().withTerm(this.context.getTerm()).withCandidate(this.context.getCluster().member().id()).withLogIndex(lastIndex).withLogTerm(lastTerm).build();
            this.context.getConnections().getConnection(member.serverAddress()).thenAccept(connection -> connection.sendAndReceive(request).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.LOGGER.warn(error.getMessage());
                        quorum.fail();
                    } else if (response.term() > this.context.getTerm()) {
                        this.LOGGER.trace("{} - Received greater term from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                        this.context.setTerm(response.term());
                        complete.set(true);
                        this.context.transition(CopycatServer.State.FOLLOWER);
                    } else if (!response.voted()) {
                        this.LOGGER.trace("{} - Received rejected vote from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                        quorum.fail();
                    } else if (response.term() != this.context.getTerm()) {
                        this.LOGGER.trace("{} - Received successful vote for a different term from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                        quorum.fail();
                    } else {
                        this.LOGGER.trace("{} - Received successful vote from {}", (Object)this.context.getCluster().member().address(), (Object)member);
                        quorum.succeed();
                    }
                }
            }, this.context.getThreadContext().executor()));
        }
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        if (request.term() >= this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.context.transition(CopycatServer.State.FOLLOWER);
        }
        return super.append(request);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.updateTermAndLeader(request.term(), 0)) {
            CompletableFuture<VoteResponse> future = super.vote(request);
            this.context.transition(CopycatServer.State.FOLLOWER);
            return future;
        }
        if (request.candidate() == this.context.getCluster().member().id()) {
            return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build()));
        }
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build()));
    }

    private void cancelElection() {
        this.context.checkThread();
        if (this.currentTimer != null) {
            this.LOGGER.debug("{} - Cancelling election", (Object)this.context.getCluster().member().address());
            this.currentTimer.cancel();
        }
        if (this.quorum != null) {
            this.quorum.cancel();
            this.quorum = null;
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelElection);
    }
}

