/*
 * Decompiled with CFR 0.152.
 */
package io.atomix;

import io.atomix.Atomix;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.transport.local.LocalServerRegistry;
import io.atomix.catalyst.transport.local.LocalTransport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.cluster.ClusterManager;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.cluster.Cluster;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.session.Session;
import io.atomix.manager.ResourceClient;
import io.atomix.manager.ResourceManagerException;
import io.atomix.manager.ResourceServer;
import io.atomix.manager.internal.ResourceManagerState;
import io.atomix.manager.options.ServerOptions;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class AtomixReplica
extends Atomix {
    private final ResourceServer server;
    private final ClusterManager clusterManager;

    public static Builder builder(Address address) {
        return AtomixReplica.builder(address, address);
    }

    public static Builder builder(Address clientAddress, Address serverAddress) {
        return new Builder(clientAddress, serverAddress);
    }

    public static Builder builder(Address address, Properties properties) {
        return AtomixReplica.builder(address, address, properties);
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Properties properties) {
        ServerOptions options = new ServerOptions(properties);
        return new Builder(clientAddress, serverAddress).withTransport(options.transport()).withResourceTypes(options.resourceTypes()).withStorage(Storage.builder().withStorageLevel(options.storageLevel()).withDirectory(options.storageDirectory()).withMaxSegmentSize(options.maxSegmentSize()).withMaxEntriesPerSegment(options.maxEntriesPerSegment()).withRetainStaleSnapshots(options.retainStaleSnapshots()).withCompactionThreads(options.compactionThreads()).withMinorCompactionInterval(options.minorCompactionInterval()).withMajorCompactionInterval(options.majorCompactionInterval()).withCompactionThreshold(options.compactionThreshold()).build()).withSerializer(options.serializer()).withElectionTimeout(options.electionTimeout()).withHeartbeatInterval(options.heartbeatInterval()).withSessionTimeout(options.sessionTimeout());
    }

    private AtomixReplica(ResourceClient client, ResourceServer server, ClusterManager clusterManager) {
        super(client);
        this.server = Assert.notNull(server, "server");
        this.clusterManager = Assert.notNull(clusterManager, "clusterManager");
    }

    public ResourceServer server() {
        return this.server;
    }

    public Type type() {
        Member.Type type = this.server.server().cluster().member().type();
        if (type == null || type == Member.Type.INACTIVE) {
            return null;
        }
        return Type.valueOf(type.name());
    }

    public CompletableFuture<AtomixReplica> bootstrap() {
        return this.bootstrap(Collections.EMPTY_LIST);
    }

    public CompletableFuture<AtomixReplica> bootstrap(Address ... cluster) {
        return this.bootstrap(Arrays.asList(cluster));
    }

    public CompletableFuture<AtomixReplica> bootstrap(Collection<Address> cluster) {
        return ((CompletableFuture)((CompletableFuture)this.server.bootstrap(cluster).thenCompose(v -> this.clusterManager.start(this.server.server().cluster(), this))).thenCompose(v -> this.client.connect(cluster))).thenApply(v -> this);
    }

    public CompletableFuture<AtomixReplica> join(Address ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    public CompletableFuture<AtomixReplica> join(Collection<Address> cluster) {
        return ((CompletableFuture)((CompletableFuture)this.server.join(cluster).thenCompose(v -> this.clusterManager.start(this.server.server().cluster(), this))).thenCompose(v -> this.client.connect(cluster))).thenApply(v -> this);
    }

    public CompletableFuture<Void> shutdown() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.clusterManager.stop(this.server.server().cluster(), this).whenComplete((managerResult, managerError) -> this.client.close().whenComplete((clientResult, clientError) -> this.server.shutdown().whenComplete((serverResult, serverError) -> {
            if (managerError != null) {
                future.completeExceptionally((Throwable)managerError);
            } else if (clientError != null) {
                future.completeExceptionally((Throwable)clientError);
            } else if (serverError != null) {
                future.completeExceptionally((Throwable)serverError);
            } else {
                future.complete(null);
            }
        })));
        return future;
    }

    public CompletableFuture<Void> leave() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.clusterManager.stop(this.server.server().cluster(), this).whenComplete((managerResult, managerError) -> this.client.close().whenComplete((clientResult, clientError) -> this.server.leave().whenComplete((serverResult, serverError) -> {
            if (managerError != null) {
                future.completeExceptionally((Throwable)managerError);
            } else if (clientError != null) {
                future.completeExceptionally((Throwable)clientError);
            } else if (serverError != null) {
                future.completeExceptionally((Throwable)serverError);
            } else {
                future.complete(null);
            }
        })));
        return future;
    }

    private static class CombinedServer
    implements Server {
        private final Server local;
        private final Server remote;

        private CombinedServer(Server local, Server remote) {
            this.local = local;
            this.remote = remote;
        }

        @Override
        public CompletableFuture<Void> listen(Address address, Consumer<Connection> listener) {
            Assert.notNull(address, "address");
            Assert.notNull(listener, "listener");
            return this.local.listen(address, listener).thenCompose(v -> this.remote.listen(address, listener));
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.local.close().thenCompose(v -> this.remote.close());
        }
    }

    private static class CombinedServerTransport
    implements Transport {
        private final Transport local;
        private final Transport remote;

        private CombinedServerTransport(Transport local, Transport remote) {
            this.local = local;
            this.remote = remote;
        }

        @Override
        public Client client() {
            return this.remote.client();
        }

        @Override
        public Server server() {
            return new CombinedServer(this.local.server(), this.remote.server());
        }
    }

    private static class CombinedClient
    implements Client {
        private final Address address;
        private final Client local;
        private final Client remote;

        private CombinedClient(Address address, Client local, Client remote) {
            this.address = address;
            this.local = local;
            this.remote = remote;
        }

        @Override
        public CompletableFuture<Connection> connect(Address address) {
            if (this.address.equals(address)) {
                return this.local.connect(address);
            }
            return this.remote.connect(address);
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.remote.close().thenRun(this.local::close);
        }
    }

    private static class CombinedClientTransport
    implements Transport {
        private final Address address;
        private final Transport local;
        private final Transport remote;

        private CombinedClientTransport(Address address, Transport local, Transport remote) {
            this.address = address;
            this.local = local;
            this.remote = remote;
        }

        @Override
        public Client client() {
            return new CombinedClient(this.address, this.local.client(), this.remote.client());
        }

        @Override
        public Server server() {
            return this.remote.server();
        }
    }

    private static class CombinedSelectionStrategy
    implements ServerSelectionStrategy {
        private final Address address;

        private CombinedSelectionStrategy(Address address) {
            this.address = address;
        }

        @Override
        public List<Address> selectConnections(Address leader, List<Address> servers) {
            ArrayList<Address> addresses = new ArrayList<Address>(servers.size());
            addresses.add(this.address);
            Collections.shuffle(servers);
            for (Address address : servers) {
                if (address.equals(this.address)) continue;
                addresses.add(address);
            }
            return addresses;
        }
    }

    private static final class CombinedCopycatClient
    implements CopycatClient {
        private final CopycatClient client;
        private final Transport transport;

        CombinedCopycatClient(CopycatClient client, Transport transport) {
            this.client = Assert.notNull(client, "client");
            this.transport = Assert.notNull(transport, "transport");
        }

        @Override
        public CopycatClient.State state() {
            return this.client.state();
        }

        @Override
        public Listener<CopycatClient.State> onStateChange(Consumer<CopycatClient.State> consumer) {
            return this.client.onStateChange(consumer);
        }

        @Override
        public ThreadContext context() {
            return this.client.context();
        }

        @Override
        public Transport transport() {
            return this.transport;
        }

        @Override
        public Serializer serializer() {
            return this.client.serializer();
        }

        @Override
        public Session session() {
            return this.client.session();
        }

        @Override
        public <T> CompletableFuture<T> submit(Command<T> command) {
            return this.client.submit(command);
        }

        @Override
        public <T> CompletableFuture<T> submit(Query<T> query) {
            return this.client.submit(query);
        }

        @Override
        public Listener<Void> onEvent(String event, Runnable callback) {
            return this.client.onEvent(event, callback);
        }

        @Override
        public <T> Listener<T> onEvent(String event, Consumer<T> callback) {
            return this.client.onEvent(event, callback);
        }

        @Override
        public CompletableFuture<CopycatClient> connect(Collection<Address> members) {
            return this.client.connect(members);
        }

        @Override
        public CompletableFuture<CopycatClient> recover() {
            return this.client.recover();
        }

        @Override
        public CompletableFuture<Void> close() {
            return this.client.close();
        }

        public String toString() {
            return this.client.toString();
        }
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<AtomixReplica> {
        private final Address clientAddress;
        private final CopycatClient.Builder clientBuilder;
        private final CopycatServer.Builder serverBuilder;
        private final ResourceRegistry registry = new ResourceRegistry(Atomix.RESOURCES);
        private Transport clientTransport;
        private Transport serverTransport;
        private ClusterManager clusterManager;
        private LocalServerRegistry localRegistry = new LocalServerRegistry();

        private Builder(Address clientAddress, Address serverAddress) {
            Serializer serializer = new Serializer();
            this.clientAddress = Assert.notNull(clientAddress, "clientAddress");
            this.clientBuilder = CopycatClient.builder().withSerializer(serializer.clone()).withServerSelectionStrategy(ServerSelectionStrategies.ANY).withConnectionStrategy(ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy(RecoveryStrategies.RECOVER);
            this.serverBuilder = CopycatServer.builder(clientAddress, serverAddress).withSerializer(serializer.clone());
        }

        public Builder withType(Type type) {
            this.serverBuilder.withType(Member.Type.valueOf(Assert.notNull(type, "type").name()));
            return this;
        }

        public Builder withTransport(Transport transport) {
            this.serverTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withClientTransport(Transport transport) {
            this.clientTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withServerTransport(Transport transport) {
            this.serverTransport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.clientBuilder.withSerializer(serializer);
            this.serverBuilder.withSerializer(serializer);
            return this;
        }

        public Builder withClusterManager(ClusterManager clusterManager) {
            this.clusterManager = Assert.notNull(clusterManager, "clusterManager");
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.serverBuilder.withStorage(storage);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            this.serverBuilder.withElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            this.serverBuilder.withHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.clientBuilder.withSessionTimeout(sessionTimeout);
            this.serverBuilder.withSessionTimeout(sessionTimeout);
            return this;
        }

        public Builder withGlobalSuspendTimeout(Duration globalSuspendTimeout) {
            this.serverBuilder.withGlobalSuspendTimeout(globalSuspendTimeout);
            return this;
        }

        public Builder withResourceTypes(Class<? extends Resource<?>> ... types) {
            if (types != null) {
                return this.withResourceTypes(Arrays.asList(types).stream().map(ResourceType::new).collect(Collectors.toList()));
            }
            return this;
        }

        public Builder withResourceTypes(ResourceType ... types) {
            if (types != null) {
                return this.withResourceTypes(Arrays.asList(types));
            }
            return this;
        }

        public Builder withResourceTypes(Collection<ResourceType> types) {
            types.forEach(this.registry::register);
            return this;
        }

        public Builder addResourceType(Class<? extends Resource<?>> type) {
            return this.addResourceType(new ResourceType(type));
        }

        public Builder addResourceType(ResourceType type) {
            this.registry.register(type);
            return this;
        }

        @Override
        public AtomixReplica build() {
            ClusterManager clusterManager;
            if (this.serverTransport == null) {
                try {
                    this.serverTransport = (Transport)Class.forName("io.atomix.catalyst.transport.netty.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            this.clientBuilder.withTransport(new CombinedClientTransport(this.clientAddress, new LocalTransport(this.localRegistry), this.clientTransport != null ? this.clientTransport : this.serverTransport)).withServerSelectionStrategy(new CombinedSelectionStrategy(this.clientAddress));
            CopycatClient client = this.clientBuilder.build();
            client.serializer().resolve(new ResourceManagerTypeResolver());
            for (ResourceType type : this.registry.types()) {
                try {
                    type.factory().newInstance().createSerializableTypeResolver().resolve(client.serializer().registry());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceManagerException(e);
                }
            }
            ClusterManager clusterManager2 = clusterManager = this.clusterManager != null ? this.clusterManager : new ClusterManager(){

                @Override
                public CompletableFuture<Void> start(Cluster cluster, AtomixReplica replica) {
                    return CompletableFuture.completedFuture(null);
                }

                @Override
                public CompletableFuture<Void> stop(Cluster cluster, AtomixReplica replica) {
                    return CompletableFuture.completedFuture(null);
                }
            };
            if (this.clientTransport != null) {
                this.serverBuilder.withClientTransport(new CombinedServerTransport(new LocalTransport(this.localRegistry), this.clientTransport)).withServerTransport(this.serverTransport);
            } else {
                this.serverBuilder.withTransport(new CombinedServerTransport(new LocalTransport(this.localRegistry), this.serverTransport));
            }
            this.serverBuilder.withStateMachine(ResourceManagerState::new);
            CopycatServer server = this.serverBuilder.build();
            server.serializer().resolve(new ResourceManagerTypeResolver());
            for (ResourceType type : this.registry.types()) {
                try {
                    type.factory().newInstance().createSerializableTypeResolver().resolve(server.serializer().registry());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceManagerException(e);
                }
            }
            return new AtomixReplica(new ResourceClient(new CombinedCopycatClient(client, this.serverTransport)), new ResourceServer(server), clusterManager);
        }
    }

    public static enum Type {
        ACTIVE,
        PASSIVE,
        RESERVE;

    }
}

