/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.DataRecordBeginComparator;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Utility {
    public static int extractInteger(byte[] info, int start, int length) {
        return Integer.parseInt(Utility.extractString(info, start, length));
    }

    public static String extractString(byte[] info, int start, int length) {
        byte[] subbytes = new byte[length];
        System.arraycopy(info, start, subbytes, 0, length);
        return new String(subbytes);
    }

    public static String extractVarString(byte[] info, int start, int maxLength) {
        return Utility.extractTermString(info, start, maxLength, (byte)126);
    }

    public static String extractNullTermString(byte[] info, int start, int maxLength) {
        return Utility.extractTermString(info, start, maxLength, (byte)0);
    }

    public static void writeNullTermString(String value, int maxLength, DataOutput out) throws IOException {
        String s = value;
        if (s.length() > maxLength) {
            s = s.substring(0, maxLength);
        }
        out.writeBytes(s);
        for (int i = s.length(); i < maxLength; ++i) {
            out.write(0);
        }
    }

    static String extractTermString(byte[] info, int start, int maxLength, byte termChar) {
        int length;
        for (length = 0; length < maxLength && start + length < info.length && info[start + length] != termChar; ++length) {
        }
        if (length == 0) {
            return "";
        }
        byte[] tmp = new byte[length];
        System.arraycopy(info, start, tmp, 0, length);
        return new String(tmp);
    }

    public static short bytesToShort(byte hi, byte low, boolean swapBytes) {
        if (swapBytes) {
            return (short)((hi & 0xFF) + ((low & 0xFF) << 8));
        }
        return (short)(((hi & 0xFF) << 8) + (low & 0xFF));
    }

    public static int bytesToInt(byte a) {
        return a;
    }

    public static int uBytesToInt(byte a) {
        return a & 0xFF;
    }

    public static int bytesToInt(byte[] info, int start, boolean swapBytes) {
        return Utility.bytesToInt(info[start], info[start + 1], info[start + 2], info[start + 3], swapBytes);
    }

    public static long bytesToLong(byte[] info, int start, boolean swapBytes) {
        return Utility.bytesToLong(info[start], info[start + 1], info[start + 2], info[start + 3], info[start + 4], info[start + 5], info[start + 6], info[start + 7], swapBytes);
    }

    public static int bytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public static int uBytesToInt(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8);
        }
        return ((a & 0xFF) << 8) + (b & 0xFF);
    }

    public static int bytesToInt(byte a, byte b, byte c, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + (c << 16);
        }
        return (a << 16) + ((b & 0xFF) << 8) + (c & 0xFF);
    }

    public static int bytesToInt(byte a, byte b, byte c, byte d, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    public static long bytesToLong(byte a, byte b, byte c, byte d, byte e, byte f, byte g, byte h, boolean swapBytes) {
        if (swapBytes) {
            return ((long)a & 0xFFL) + (((long)b & 0xFFL) << 8) + (((long)c & 0xFFL) << 16) + (((long)d & 0xFFL) << 24) + (((long)e & 0xFFL) << 32) + (((long)f & 0xFFL) << 40) + (((long)g & 0xFFL) << 48) + (((long)h & 0xFFL) << 56);
        }
        return (((long)a & 0xFFL) << 56) + (((long)b & 0xFFL) << 48) + (((long)c & 0xFFL) << 40) + (((long)d & 0xFFL) << 32) + (((long)e & 0xFFL) << 24) + (((long)f & 0xFFL) << 16) + (((long)g & 0xFFL) << 8) + ((long)h & 0xFFL);
    }

    public static float bytesToFloat(byte a, byte b, byte c, byte d, boolean swapBytes) {
        return Float.intBitsToFloat(Utility.bytesToInt(a, b, c, d, swapBytes));
    }

    public static double bytesToDouble(byte a, byte b, byte c, byte d, byte e, byte f, byte g, byte h, boolean swapBytes) {
        return Double.longBitsToDouble(Utility.bytesToLong(a, b, c, d, e, f, g, h, swapBytes));
    }

    public static double bytesToDouble(byte[] info, int start, boolean swapBytes) {
        return Double.longBitsToDouble(Utility.bytesToLong(info, start, swapBytes));
    }

    public static float bytesToFloat(byte[] info, int start, boolean swapBytes) {
        return Float.intBitsToFloat(Utility.bytesToInt(info, start, swapBytes));
    }

    public static byte[] intToByteArray(int a) {
        byte[] returnByteArray = new byte[]{(byte)(a >> 24 & 0xFF), (byte)(a >> 16 & 0xFF), (byte)(a >> 8 & 0xFF), (byte)(a & 0xFF)};
        return returnByteArray;
    }

    public static byte[] floatToByteArray(float a) {
        return Utility.intToByteArray(Float.floatToIntBits(a));
    }

    public static byte[] longToByteArray(long a) {
        byte[] returnByteArray = new byte[]{(byte)(a >>> 56 & 0xFFL), (byte)(a >>> 48 & 0xFFL), (byte)(a >>> 40 & 0xFFL), (byte)(a >>> 32 & 0xFFL), (byte)(a >>> 24 & 0xFFL), (byte)(a >>> 16 & 0xFFL), (byte)(a >>> 8 & 0xFFL), (byte)(a & 0xFFL)};
        return returnByteArray;
    }

    public static byte[] doubleToByteArray(double d) {
        return Utility.longToByteArray(Double.doubleToLongBits(d));
    }

    public static void insertFloat(float value, byte[] dest, int pos) {
        int bits = Float.floatToIntBits(value);
        byte[] b = Utility.intToByteArray(bits);
        System.arraycopy(b, 0, dest, pos, 4);
    }

    public static byte[] pad(byte[] source, int requiredBytes, byte paddingByte) {
        if (source.length == requiredBytes) {
            return source;
        }
        byte[] returnByteArray = new byte[requiredBytes];
        System.arraycopy(source, 0, returnByteArray, 0, source.length);
        for (int i = source.length; i < requiredBytes; ++i) {
            returnByteArray[i] = paddingByte;
        }
        return returnByteArray;
    }

    public static byte[] format(byte[] source, int start, int end) {
        byte[] returnByteArray = new byte[start - end + 1];
        int j = 0;
        int i = start;
        while (i < end) {
            returnByteArray[j] = source[i];
            ++i;
            ++j;
        }
        return returnByteArray;
    }

    public static boolean areContiguous(DataRecord first, DataRecord second) {
        Btime fEnd = first.getPredictedNextStartBtime();
        Btime sBegin = second.getHeader().getStartBtime();
        return fEnd.tenthMilli == sBegin.tenthMilli && fEnd.sec == sBegin.sec && fEnd.min == sBegin.min && fEnd.hour == sBegin.hour && fEnd.jday == sBegin.jday && fEnd.year == sBegin.year;
    }

    public static List<List<DataRecord>> breakContiguous(List<DataRecord> inList) {
        ArrayList<List<DataRecord>> out = new ArrayList<List<DataRecord>>();
        ArrayList<DataRecord> subout = new ArrayList<DataRecord>();
        DataRecord prev = null;
        for (DataRecord dataRecord : inList) {
            if (prev == null) {
                out.add(subout);
            } else if (!Utility.areContiguous(prev, dataRecord)) {
                subout = new ArrayList();
                out.add(subout);
            }
            subout.add(dataRecord);
            prev = dataRecord;
        }
        return out;
    }

    public static void cleanDuplicatesOverlaps(List<DataRecord> drFromFileList) {
        Collections.sort(drFromFileList, new DataRecordBeginComparator());
        DataRecord prev = null;
        Iterator<DataRecord> itFromFileList = drFromFileList.iterator();
        while (itFromFileList.hasNext()) {
            DataRecord dataRecord = itFromFileList.next();
            if (prev != null && prev.getHeader().getStartBtime().equals(dataRecord.getHeader().getStartBtime())) {
                itFromFileList.remove();
                continue;
            }
            if (prev != null && prev.getLastSampleBtime().afterOrEquals(dataRecord.getHeader().getStartBtime())) {
                itFromFileList.remove();
                continue;
            }
            prev = dataRecord;
        }
    }
}

