/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class WaveformStreamID {
    String networkCode;
    String stationCode;
    String locationCode;
    String channelCode;
    String resourceReference;

    public WaveformStreamID(XMLEventReader reader, String elementName) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        this.networkCode = StaxUtil.pullAttribute(startE, "networkCode");
        this.stationCode = StaxUtil.pullAttribute(startE, "stationCode");
        this.locationCode = StaxUtil.pullAttribute(startE, "locationCode");
        this.channelCode = StaxUtil.pullAttribute(startE, "channelCode");
        this.resourceReference = StaxUtil.pullContiguousText(reader);
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String getLocationCode() {
        return this.locationCode;
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public String getResourceReference() {
        return this.resourceReference;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public void setResourceReference(String resourceReference) {
        this.resourceReference = resourceReference;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }
}

