/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Time {
    String value;
    Float uncertainty;
    Float lowerUncertainty;
    Float upperUncertainty;
    Float confidenceLevel;

    public Time(XMLEventReader reader, String elementName) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement(elementName, reader);
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("value")) {
                    this.value = StaxUtil.pullText(reader, "value");
                    continue;
                }
                if (elName.equals("uncertainty")) {
                    this.uncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "uncertainty")));
                    continue;
                }
                if (elName.equals("lowerUncertainty")) {
                    this.lowerUncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "lowerUncertainty")));
                    continue;
                }
                if (elName.equals("upperUncertainty")) {
                    this.upperUncertainty = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "upperUncertainty")));
                    continue;
                }
                if (elName.equals("confidenceLevel")) {
                    this.confidenceLevel = Float.valueOf(Float.parseFloat(StaxUtil.pullText(reader, "confidenceLevel")));
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            e = reader.nextEvent();
        }
    }

    public Float getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public Float getLowerUncertainty() {
        return this.lowerUncertainty;
    }

    public Float getUncertainty() {
        return this.uncertainty;
    }

    public Float getUpperUncertainty() {
        return this.upperUncertainty;
    }

    public String getValue() {
        return this.value;
    }

    public void setConfidenceLevel(Float confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public void setLowerUncertainty(Float lowerUncertainty) {
        this.lowerUncertainty = lowerUncertainty;
    }

    public void setUncertainty(Float uncertainty) {
        this.uncertainty = uncertainty;
    }

    public void setUpperUncertainty(Float upperUncertainty) {
        this.upperUncertainty = upperUncertainty;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

