/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Amplitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventDescription;
import edu.sc.seis.seisFile.fdsnws.quakeml.FocalMechanism;
import edu.sc.seis.seisFile.fdsnws.quakeml.Magnitude;
import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.quakeml.Pick;
import edu.sc.seis.seisFile.fdsnws.quakeml.StationMagnitude;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Event {
    public static final String ELEMENT_NAME = "event";
    private String preferredOriginID;
    private String preferredMagnitudeID;
    private String preferredFocalMechanismID;
    private String publicId;
    private List<EventDescription> descriptionList = new ArrayList<EventDescription>();
    private List<Magnitude> magnitudeList = new ArrayList<Magnitude>();
    private List<StationMagnitude> stationMagnitudeList = new ArrayList<StationMagnitude>();
    private List<Amplitude> amplitudeList = new ArrayList<Amplitude>();
    private List<Comment> commentList = new ArrayList<Comment>();
    private List<Pick> pickList = new ArrayList<Pick>();
    private String type;
    private int irisFECode = -1;
    private List<Origin> originList = new ArrayList<Origin>();
    private List<FocalMechanism> focalMechanismList = new ArrayList<FocalMechanism>();
    private CreationInfo creationInfo;
    private Integer dbid;

    public Event(Origin origin) {
        this.originList.add(origin);
    }

    public Event(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement(ELEMENT_NAME, reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("description")) {
                    this.descriptionList.add(new EventDescription(reader));
                    continue;
                }
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("type")) {
                    this.type = StaxUtil.pullText(reader, "type");
                    continue;
                }
                if (elName.equals("origin")) {
                    this.originList.add(new Origin(reader));
                    continue;
                }
                if (elName.equals("focalMechanism")) {
                    this.focalMechanismList.add(new FocalMechanism(reader));
                    continue;
                }
                if (elName.equals("magnitude")) {
                    this.magnitudeList.add(new Magnitude(reader));
                    continue;
                }
                if (elName.equals("stationMagnitude")) {
                    this.stationMagnitudeList.add(new StationMagnitude(reader));
                    continue;
                }
                if (elName.equals("amplitude")) {
                    this.amplitudeList.add(new Amplitude(reader));
                    continue;
                }
                if (elName.equals("pick")) {
                    this.pickList.add(new Pick(reader));
                    continue;
                }
                if (elName.equals("preferredOriginID")) {
                    this.preferredOriginID = StaxUtil.pullText(reader, "preferredOriginID");
                    continue;
                }
                if (elName.equals("preferredMagnitudeID")) {
                    this.preferredMagnitudeID = StaxUtil.pullText(reader, "preferredMagnitudeID");
                    continue;
                }
                if (elName.equals("preferredFocalMechanismID")) {
                    this.preferredFocalMechanismID = StaxUtil.pullText(reader, "preferredFocalMechanismID");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                System.err.println("Event skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public List<Amplitude> getAmplitudeList() {
        return this.amplitudeList;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public Integer getDbid() {
        return this.dbid;
    }

    public List<EventDescription> getDescriptionList() {
        return this.descriptionList;
    }

    public List<FocalMechanism> getFocalMechanismList() {
        return this.focalMechanismList;
    }

    public int getIrisFECode() {
        return this.irisFECode;
    }

    public List<Magnitude> getMagnitudeList() {
        return this.magnitudeList;
    }

    public List<Origin> getOriginList() {
        return this.originList;
    }

    public List<Pick> getPickList() {
        return this.pickList;
    }

    public String getPreferredFocalMechanismID() {
        return this.preferredFocalMechanismID;
    }

    public Magnitude getPreferredMagnitude() {
        for (Magnitude mag : this.getMagnitudeList()) {
            if (!mag.getPublicId().equals(this.getPreferredMagnitudeID())) continue;
            return mag;
        }
        return null;
    }

    public String getPreferredMagnitudeID() {
        return this.preferredMagnitudeID;
    }

    public String getPreferredOriginID() {
        return this.preferredOriginID;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public List<StationMagnitude> getStationMagnitudeList() {
        return this.stationMagnitudeList;
    }

    public String getType() {
        return this.type;
    }

    public void setAmplitudeList(List<Amplitude> amplitudeList) {
        this.amplitudeList = amplitudeList;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setDbid(Integer dbid) {
        this.dbid = dbid;
    }

    public void setDescriptionList(List<EventDescription> descriptionList) {
        this.descriptionList = descriptionList;
    }

    public void setFocalMechanismList(List<FocalMechanism> focalMechanismList) {
        this.focalMechanismList = focalMechanismList;
    }

    public void setIrisFECode(int irisFECode) {
        this.irisFECode = irisFECode;
    }

    public void setMagnitudeList(List<Magnitude> magnitudeList) {
        this.magnitudeList = magnitudeList;
    }

    public void setOriginList(List<Origin> originList) {
        this.originList = originList;
    }

    public void setPickList(List<Pick> pickList) {
        this.pickList = pickList;
    }

    public void setPreferredFocalMechanismID(String preferredFocalMechanismID) {
        this.preferredFocalMechanismID = preferredFocalMechanismID;
    }

    public void setPreferredMagnitudeID(String preferredMagnitudeID) {
        this.preferredMagnitudeID = preferredMagnitudeID;
    }

    public void setPreferredOriginID(String preferredOriginID) {
        this.preferredOriginID = preferredOriginID;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setStationMagnitudeList(List<StationMagnitude> stationMagnitudeList) {
        this.stationMagnitudeList = stationMagnitudeList;
    }

    public void setType(String type) {
        this.type = type;
    }
}

