/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.Comment;
import edu.sc.seis.seisFile.fdsnws.quakeml.CreationInfo;
import edu.sc.seis.seisFile.fdsnws.quakeml.RealQuantity;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Arrival {
    String publicId;
    String phase;
    float azimuth;
    float distance;
    RealQuantity takeoffAngle;
    float timeResidual;
    float timeCorrection;
    Float horizontalSlownessWeight;
    Float backazimuthWeight;
    Float horizontalSlownessResidual;
    Float backazimuthResidual;
    Float timeWeight;
    String earthModelID;
    String pickID;
    CreationInfo creationInfo;
    List<Comment> commentList = new ArrayList<Comment>();

    public Arrival(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        StartElement startE = StaxUtil.expectStartElement("arrival", reader);
        this.publicId = StaxUtil.pullAttribute(startE, "publicID");
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("comment")) {
                    this.commentList.add(new Comment(reader));
                    continue;
                }
                if (elName.equals("phase")) {
                    this.phase = StaxUtil.pullText(reader, "phase");
                    continue;
                }
                if (elName.equals("azimuth")) {
                    this.azimuth = StaxUtil.pullFloat(reader, "azimuth");
                    continue;
                }
                if (elName.equals("distance")) {
                    this.distance = StaxUtil.pullFloat(reader, "distance");
                    continue;
                }
                if (elName.equals("takeoffAngle")) {
                    this.takeoffAngle = new RealQuantity(reader, "takeoffAngle");
                    continue;
                }
                if (elName.equals("timeResidual")) {
                    this.timeResidual = StaxUtil.pullFloat(reader, "timeResidual");
                    continue;
                }
                if (elName.equals("horizontalSlownessResidual")) {
                    this.horizontalSlownessResidual = Float.valueOf(StaxUtil.pullFloat(reader, "horizontalSlownessResidual"));
                    continue;
                }
                if (elName.equals("backazimuthResidual")) {
                    this.backazimuthResidual = Float.valueOf(StaxUtil.pullFloat(reader, "backazimuthResidual"));
                    continue;
                }
                if (elName.equals("timeWeight")) {
                    this.timeWeight = Float.valueOf(StaxUtil.pullFloat(reader, "timeWeight"));
                    continue;
                }
                if (elName.equals("backazimuthWeight")) {
                    this.backazimuthWeight = Float.valueOf(StaxUtil.pullFloat(reader, "backazimuthWeight"));
                    continue;
                }
                if (elName.equals("horizontalSlownessWeight")) {
                    this.horizontalSlownessWeight = Float.valueOf(StaxUtil.pullFloat(reader, "horizontalSlownessWeight"));
                    continue;
                }
                if (elName.equals("timeCorrection")) {
                    this.timeCorrection = StaxUtil.pullFloat(reader, "timeCorrection");
                    continue;
                }
                if (elName.equals("earthModelID")) {
                    this.earthModelID = StaxUtil.pullText(reader, "earthModelID");
                    continue;
                }
                if (elName.equals("phase")) {
                    this.phase = StaxUtil.pullText(reader, "phase");
                    continue;
                }
                if (elName.equals("pickID")) {
                    this.pickID = StaxUtil.pullText(reader, "pickID");
                    continue;
                }
                if (elName.equals("creationInfo")) {
                    this.creationInfo = new CreationInfo(reader);
                    continue;
                }
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public float getAzimuth() {
        return this.azimuth;
    }

    public Float getBackazimuthResidual() {
        return this.backazimuthResidual;
    }

    public Float getBackazimuthWeight() {
        return this.backazimuthWeight;
    }

    public List<Comment> getCommentList() {
        return this.commentList;
    }

    public CreationInfo getCreationInfo() {
        return this.creationInfo;
    }

    public float getDistance() {
        return this.distance;
    }

    public String getEarthModelID() {
        return this.earthModelID;
    }

    public Float getHorizontalSlownessResidual() {
        return this.horizontalSlownessResidual;
    }

    public Float getHorizontalSlownessWeight() {
        return this.horizontalSlownessWeight;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getPickID() {
        return this.pickID;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public RealQuantity getTakeoffAngle() {
        return this.takeoffAngle;
    }

    public float getTimeCorrection() {
        return this.timeCorrection;
    }

    public float getTimeResidual() {
        return this.timeResidual;
    }

    public Float getTimeWeight() {
        return this.timeWeight;
    }

    public void setAzimuth(float azimuth) {
        this.azimuth = azimuth;
    }

    public void setBackazimuthResidual(Float backazimuthResidual) {
        this.backazimuthResidual = backazimuthResidual;
    }

    public void setBackazimuthWeight(Float backazimuthWeight) {
        this.backazimuthWeight = backazimuthWeight;
    }

    public void setCommentList(List<Comment> commentList) {
        this.commentList = commentList;
    }

    public void setCreationInfo(CreationInfo creationInfo) {
        this.creationInfo = creationInfo;
    }

    public void setDistance(float distance) {
        this.distance = distance;
    }

    public void setEarthModelID(String earthModelID) {
        this.earthModelID = earthModelID;
    }

    public void setHorizontalSlownessResidual(Float horizontalSlownessResidual) {
        this.horizontalSlownessResidual = horizontalSlownessResidual;
    }

    public void setHorizontalSlownessWeight(Float horizontalSlownessWeight) {
        this.horizontalSlownessWeight = horizontalSlownessWeight;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setPickID(String pickID) {
        this.pickID = pickID;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public void setTakeoffAngle(RealQuantity takeoffAngle) {
        this.takeoffAngle = takeoffAngle;
    }

    public void setTimeCorrection(float timeCorrection) {
        this.timeCorrection = timeCorrection;
    }

    public void setTimeResidual(float timeResidual) {
        this.timeResidual = timeResidual;
    }

    public void setTimeWeight(Float timeWeight) {
        this.timeWeight = timeWeight;
    }
}

