/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.QueryTime;
import java.net.URI;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeQueryLog {
    static int totalQueries = 0;
    static HashMap<String, LinkedList<QueryTime>> recentQueries = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(TimeQueryLog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int add(URI uri) {
        ++totalQueries;
        QueryTime current = new QueryTime(uri);
        LinkedList<QueryTime> byHost = null;
        HashMap<String, LinkedList<QueryTime>> hashMap = recentQueries;
        synchronized (hashMap) {
            byHost = recentQueries.get(uri.getHost());
            if (byHost == null) {
                byHost = new LinkedList();
                recentQueries.put(uri.getHost(), byHost);
            }
        }
        int numLastSec = 1;
        Instant secondAgo = Instant.now().minus(TimeUtils.ONE_SECOND);
        LinkedList<QueryTime> linkedList = byHost;
        synchronized (linkedList) {
            Iterator iterator = byHost.iterator();
            while (iterator.hasNext()) {
                QueryTime timeQuery = (QueryTime)iterator.next();
                if (timeQuery.getWhen().isAfter(secondAgo)) {
                    ++numLastSec;
                    continue;
                }
                iterator.remove();
            }
            byHost.add(current);
            if (numLastSec >= 10) {
                logger.warn("More than 10 queries in last second for " + uri.getHost() + "!!! " + numLastSec);
                List<QueryTime> toPrintList = byHost;
                if (numLastSec > 10) {
                    toPrintList = byHost.subList(0, 10);
                }
                for (QueryTime timeQuery : toPrintList) {
                    logger.warn("  " + timeQuery.getWhen() + "  " + timeQuery.getURI());
                }
                if (numLastSec > 10) {
                    logger.warn("...plus " + (numLastSec - 10) + " more.");
                }
                logger.warn("Taking a little break to give the service time to catch its breath.");
                try {
                    HashMap<String, LinkedList<QueryTime>> hashMap2 = recentQueries;
                    synchronized (hashMap2) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return numLastSec;
        }
    }
}

