/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

public class EarthwormMessage {
    int institution;
    int module;
    int messageType;
    byte[] data;
    public static final byte MESSAGE_TYPE_TRACEBUF2 = 19;
    public static final byte MESSAGE_TYPE_HEARTBEAT = 3;
    public static final int MESSAGE_TYPE_MINISEED = 35;

    public EarthwormMessage(byte[] bytes) {
        if (bytes.length < 9) {
            throw new IllegalArgumentException("Message must have at least 9 bytes");
        }
        this.institution = Integer.parseInt(new String(bytes, 0, 3).trim());
        this.module = Integer.parseInt(new String(bytes, 3, 3).trim());
        this.messageType = Integer.parseInt(new String(bytes, 6, 3).trim());
        this.data = new byte[bytes.length - 9];
        System.arraycopy(bytes, 9, this.data, 0, this.data.length);
    }

    public int getInstitution() {
        return this.institution;
    }

    public int getModule() {
        return this.module;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public byte[] getData() {
        return this.data;
    }
}

