/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.sc.seis.seisFile.earthworm.EarthwormExport;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingEarthwormExport {
    Thread exportThread;
    EarthwormExport export;
    List<TraceBuf2> buffer;
    int total = 0;
    int sentCount = 0;
    int tossCount = 0;
    int maxSize;
    long sleepMillis = 50L;
    private static final Logger logger = LoggerFactory.getLogger(BufferingEarthwormExport.class);

    public BufferingEarthwormExport(int port, int module, int institution, String heartbeatMessage, int heartbeatSeconds, int bufferSize, int sleepMillis) throws UnknownHostException, IOException {
        this.export = new EarthwormExport(port, module, institution, heartbeatMessage, heartbeatSeconds);
        this.export.setVerbose(true);
        this.maxSize = bufferSize;
        this.sleepMillis = sleepMillis;
        this.buffer = Collections.synchronizedList(new ArrayList(this.maxSize));
        this.exportThread = new Thread(new Runnable(){

            @Override
            public void run() {
                TraceBuf2 tb = null;
                block4: while (true) {
                    try {
                        while (true) {
                            if (!BufferingEarthwormExport.this.export.isConnected()) {
                                try {
                                    BufferingEarthwormExport.this.export.waitForClient();
                                    continue block4;
                                }
                                catch (IOException e1) {
                                    logger.error("Problem waiting for client connection, retry", (Throwable)e1);
                                    continue;
                                }
                            }
                            if (tb == null) {
                                tb = BufferingEarthwormExport.this.pop();
                            }
                            if (tb != null) {
                                logger.info("Try to send " + tb);
                                BufferingEarthwormExport.this.export.export(tb);
                                ++BufferingEarthwormExport.this.sentCount;
                                tb = null;
                            }
                            if (BufferingEarthwormExport.this.export.inStream.available() > 0) {
                                byte[] availableInBytes = new byte[BufferingEarthwormExport.this.export.inStream.available()];
                                BufferingEarthwormExport.this.export.inStream.read(availableInBytes);
                                logger.info("possible heartbeat: " + availableInBytes[0] + " " + availableInBytes[1] + " " + availableInBytes[2]);
                            }
                            Thread.sleep(BufferingEarthwormExport.this.getSleepMillis());
                        }
                    }
                    catch (Throwable t) {
                        BufferingEarthwormExport.this.export.closeSocket();
                        logger.error("problem sending " + tb, t);
                        continue;
                    }
                    break;
                }
            }
        });
        this.exportThread.setDaemon(true);
        this.exportThread.setName("exportThread");
        this.exportThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(TraceBuf2 tb) {
        ++this.total;
        List<TraceBuf2> list = this.buffer;
        synchronized (list) {
            if (this.buffer.size() == this.maxSize) {
                this.pop();
                ++this.tossCount;
            }
            this.buffer.add(tb);
            logger.info("Offered, " + this.buffer.size() + " left: " + this.sentCount + "+" + this.tossCount + " = " + this.total);
            this.buffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TraceBuf2 pop() {
        List<TraceBuf2> list = this.buffer;
        synchronized (list) {
            while (this.buffer.isEmpty()) {
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            TraceBuf2 out = this.buffer.remove(0);
            this.buffer.notifyAll();
            return out;
        }
    }

    public int getTotal() {
        return this.total;
    }

    public int getSentCount() {
        return this.sentCount;
    }

    public int getTossCount() {
        return this.tossCount;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public void setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
    }
}

