/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.datalink;

public class DataLinkHeader {
    private String headerString;
    private String[] headerSplit;
    private String key;
    private int dataSize = 0;

    public DataLinkHeader(String headerString) {
        this.headerString = headerString;
        this.headerSplit = headerString.split(" ");
        this.key = this.headerSplit[0];
        if (this.key.equals("INFO") || this.key.equals("PACKET") || this.key.equals("OK") || this.key.equals("ERROR")) {
            this.dataSize = Integer.parseInt(this.headerSplit[this.headerSplit.length - 1]);
        }
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public String headerSplit(int index) {
        return this.headerSplit[index];
    }

    public String getKey() {
        return this.key;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public boolean isMessageType() {
        return this.getKey().startsWith("ID") || this.key.startsWith("INFO") || this.key.startsWith("OK") || this.key.startsWith("ERROR") || this.key.startsWith("ENDSTREAM");
    }

    public String toString() {
        return this.headerString;
    }
}

