/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber.digester;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.asn1.ber.BERDecoder;
import org.apache.asn1.ber.BERDecoderCallback;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.digester.BERDigesterLoggingMonitor;
import org.apache.asn1.ber.digester.BERDigesterMonitor;
import org.apache.asn1.ber.digester.Rule;
import org.apache.asn1.ber.digester.Rules;
import org.apache.asn1.ber.digester.RulesBase;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.AbstractStatefulDecoder;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.primitives.BooleanStack;
import org.apache.commons.collections.primitives.ByteStack;
import org.apache.commons.collections.primitives.CharStack;
import org.apache.commons.collections.primitives.DoubleStack;
import org.apache.commons.collections.primitives.FloatStack;
import org.apache.commons.collections.primitives.IntStack;
import org.apache.commons.collections.primitives.LongStack;
import org.apache.commons.collections.primitives.ShortStack;

public class BERDigester
extends AbstractStatefulDecoder {
    public static final int NO_TOP_TAG = 0xF000000;
    private BERDecoder decoder;
    private ArrayStack objectStack;
    private BooleanStack booleanStack;
    private CharStack charStack;
    private FloatStack floatStack;
    private DoubleStack doubleStack;
    private IntStack intStack;
    private ByteStack byteStack;
    private LongStack longStack;
    private ShortStack shortStack;
    private IntStack tagStack;
    private Rules rules = new RulesBase();
    private List matched;
    private ClassLoader classLoader = null;
    private boolean useContextClassLoader = false;
    private Object root = null;
    private BERDigesterMonitor monitor = null;

    public BERDigester() {
        this.rules.setDigester(this);
        this.tagStack = new IntStack();
        this.objectStack = new ArrayStack();
        this.booleanStack = new BooleanStack();
        this.charStack = new CharStack();
        this.byteStack = new ByteStack();
        this.shortStack = new ShortStack();
        this.intStack = new IntStack();
        this.longStack = new LongStack();
        this.floatStack = new FloatStack();
        this.doubleStack = new DoubleStack();
        this.decoder = new BERDecoder();
        this.decoder.setCallback(new DigesterCallback());
        this.monitor = new BERDigesterLoggingMonitor();
    }

    public void decode(Object encoded) throws DecoderException {
        this.decoder.decode(encoded);
    }

    public void addRule(int[] pattern, Rule rule) {
        this.rules.add(pattern, rule);
        rule.setDigester(this);
    }

    public Rules getRules() {
        return this.rules;
    }

    public void clear() {
        this.root = null;
        this.tagStack.clear();
        this.objectStack.clear();
        this.booleanStack.clear();
        this.byteStack.clear();
        this.shortStack.clear();
        this.intStack.clear();
        this.longStack.clear();
        this.floatStack.clear();
        this.doubleStack.clear();
    }

    public int getCount() {
        return this.objectStack.size();
    }

    public Object peek() {
        return this.objectStack.peek();
    }

    public Object peek(int n) {
        return this.objectStack.peek(n);
    }

    public Object pop() {
        return this.objectStack.pop();
    }

    public void push(Object object) {
        if (this.objectStack.size() == 0) {
            this.root = object;
        }
        this.objectStack.push(object);
    }

    public int getBooleanCount() {
        return this.booleanStack.size();
    }

    public boolean peekBoolean() {
        return this.booleanStack.peek();
    }

    public boolean peekBoolean(int n) {
        return this.booleanStack.peek(n);
    }

    public boolean popBoolean() {
        return this.booleanStack.pop();
    }

    public void pushBoolean(boolean bit) {
        this.booleanStack.push(bit);
    }

    public int getCharCount() {
        return this.charStack.size();
    }

    public char peekChar() {
        return this.charStack.peek();
    }

    public char peekChar(int n) {
        return this.charStack.peek(n);
    }

    public char popChar() {
        return this.charStack.pop();
    }

    public void pushChar(char ch) {
        this.charStack.push(ch);
    }

    public int getByteCount() {
        return this.byteStack.size();
    }

    public byte peekByte() {
        return this.byteStack.peek();
    }

    public byte peekByte(int n) {
        return this.byteStack.peek(n);
    }

    public byte popByte() {
        return this.byteStack.pop();
    }

    public void pushByte(byte bite) {
        this.byteStack.push(bite);
    }

    public int getShortCount() {
        return this.shortStack.size();
    }

    public short peekShort() {
        return this.shortStack.peek();
    }

    public short peekShort(int n) {
        return this.shortStack.peek(n);
    }

    public short popShort() {
        return this.shortStack.pop();
    }

    public void pushShort(short element) {
        this.shortStack.push(element);
    }

    public int getIntCount() {
        return this.intStack.size();
    }

    public int peekInt() {
        return this.intStack.peek();
    }

    public int peekInt(int n) {
        return this.intStack.peek(n);
    }

    public int popInt() {
        return this.intStack.pop();
    }

    public void pushInt(int element) {
        this.intStack.push(element);
    }

    public int getLongCount() {
        return this.longStack.size();
    }

    public long peekLong() {
        return this.longStack.peek();
    }

    public long peekLong(int n) {
        return this.longStack.peek(n);
    }

    public long popLong() {
        return this.longStack.pop();
    }

    public void pushLong(long element) {
        this.longStack.push(element);
    }

    public int getFloatCount() {
        return this.floatStack.size();
    }

    public float peekFloat() {
        return this.floatStack.peek();
    }

    public float peekFloat(int n) {
        return this.floatStack.peek(n);
    }

    public float popFloat() {
        return this.floatStack.pop();
    }

    public void pushFloat(float element) {
        this.floatStack.push(element);
    }

    public int getDoubleCount() {
        return this.doubleStack.size();
    }

    public double peekDouble() {
        return this.doubleStack.peek();
    }

    public double peekDouble(int n) {
        return this.doubleStack.peek(n);
    }

    public double popDouble() {
        return this.doubleStack.pop();
    }

    public void pushDouble(double element) {
        this.doubleStack.push(element);
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRules(Rules rules) {
        this.rules = rules;
        this.rules.setDigester(this);
    }

    public int getTagCount() {
        return this.tagStack.size();
    }

    public int getTag(int n) {
        return this.tagStack.peek(n);
    }

    public int getTopTag() {
        if (this.tagStack.size() <= 0) {
            return 0xF000000;
        }
        return this.tagStack.peek();
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader;
        if (this.classLoader != null) {
            return this.classLoader;
        }
        if (this.useContextClassLoader && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
            return classLoader;
        }
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    void fireTagEvent(int id, boolean isPrimitive, TypeClass typeClass) {
        Iterator rules = null;
        rules = this.matched == null ? Collections.EMPTY_LIST.iterator() : this.matched.iterator();
        while (rules.hasNext()) {
            Rule rule = (Rule)rules.next();
            try {
                rule.tag(id, isPrimitive, typeClass);
            }
            catch (RuntimeException e) {
                this.monitor.ruleFailed(this, rule, "Rule.tag() threw exception", e);
                throw e;
            }
            catch (Error e) {
                this.monitor.ruleFailed(this, rule, "Rule.tag() threw error", e);
                throw e;
            }
        }
    }

    void fireLengthEvent(int length) {
        Iterator rules = null;
        rules = this.matched == null ? Collections.EMPTY_LIST.iterator() : this.matched.iterator();
        while (rules.hasNext()) {
            Rule rule = (Rule)rules.next();
            try {
                rule.length(length);
            }
            catch (RuntimeException e) {
                this.monitor.ruleFailed(this, rule, "Rule.length() threw exception", e);
                throw e;
            }
            catch (Error e) {
                this.monitor.ruleFailed(this, rule, "Rule.length() threw error", e);
                throw e;
            }
        }
    }

    void fireValueEvent(ByteBuffer buf) {
        Iterator rules = null;
        rules = this.matched == null ? Collections.EMPTY_LIST.iterator() : this.matched.iterator();
        while (rules.hasNext()) {
            Rule rule = (Rule)rules.next();
            try {
                rule.value(buf);
                buf.rewind();
            }
            catch (RuntimeException e) {
                this.monitor.ruleFailed(this, rule, "Rule.value() threw exception", e);
                throw e;
            }
            catch (Error e) {
                this.monitor.ruleFailed(this, rule, "Rule.value() threw exception", e);
                throw e;
            }
        }
    }

    void fireFinishEvent() {
        Rule rule = null;
        HashSet<Rule> seen = null;
        if (this.matched != null) {
            seen = new HashSet<Rule>();
            for (int i = 0; i < this.matched.size(); ++i) {
                try {
                    rule = (Rule)this.matched.get(i);
                    rule.finish();
                    this.monitor.ruleCompleted(this, rule);
                    seen.add(rule);
                    continue;
                }
                catch (RuntimeException e) {
                    this.monitor.ruleFailed(this, rule, "Rule.finish() threw exception", e);
                    throw e;
                }
                catch (Error e) {
                    this.monitor.ruleFailed(this, rule, "Rule.finish() threw error", e);
                    throw e;
                }
            }
        }
    }

    class DigesterCallback
    implements BERDecoderCallback {
        DigesterCallback() {
        }

        public void tagDecoded(Tuple tlv) {
            BERDigester.this.tagStack.push(tlv.getRawPrimitiveTag());
            BERDigester.this.matched = BERDigester.this.rules.match(BERDigester.this.tagStack);
            BERDigester.this.fireTagEvent(tlv.getId(), tlv.isPrimitive(), tlv.getTypeClass());
        }

        public void lengthDecoded(Tuple tlv) {
            BERDigester.this.fireLengthEvent(tlv.getLength());
        }

        public void partialValueDecoded(Tuple tlv) {
            BERDigester.this.fireValueEvent(tlv.getLastValueChunk());
        }

        public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
            BERDigester.this.matched = BERDigester.this.rules.match(BERDigester.this.tagStack);
            BERDigester.this.fireFinishEvent();
            BERDigester.this.tagStack.pop();
            if (BERDigester.this.tagStack.empty()) {
                BERDigester.this.decodeOccurred(BERDigester.this.getRoot());
            }
        }
    }
}

