/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

public class TypeClass {
    public static final int UNIVERSAL_VAL = 0;
    public static final int APPLICATION_VAL = 64;
    public static final int CONTEXT_SPECIFIC_VAL = 128;
    public static final int PRIVATE_VAL = 192;
    public static final TypeClass UNIVERSAL = new TypeClass("UNIVERSAL", 0);
    public static final TypeClass APPLICATION = new TypeClass("APPLICATION", 64);
    public static final TypeClass CONTEXT_SPECIFIC = new TypeClass("CONTEXT_SPECIFIC", 128);
    public static final TypeClass PRIVATE = new TypeClass("PRIVATE", 192);
    private final String name;
    private final int value;

    private TypeClass(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public final String getName() {
        return this.name;
    }

    public final int getValue() {
        return this.value;
    }

    public static TypeClass getTypeClass(String className) {
        if (className == APPLICATION.getName()) {
            return APPLICATION;
        }
        if (className == CONTEXT_SPECIFIC.getName()) {
            return CONTEXT_SPECIFIC;
        }
        if (className == PRIVATE.getName()) {
            return PRIVATE;
        }
        if (className == UNIVERSAL.getName()) {
            return UNIVERSAL;
        }
        if (className.equalsIgnoreCase(PRIVATE.getName())) {
            return PRIVATE;
        }
        if (className.equalsIgnoreCase(UNIVERSAL.getName())) {
            return UNIVERSAL;
        }
        if (className.equalsIgnoreCase(APPLICATION.getName())) {
            return APPLICATION;
        }
        if (className.equalsIgnoreCase(CONTEXT_SPECIFIC.getName())) {
            return CONTEXT_SPECIFIC;
        }
        throw new IllegalArgumentException("Unknown type class name" + className);
    }

    public static TypeClass getTypeClass(int octet) {
        TypeClass tc = null;
        int l_value = octet & 0xC0;
        switch (l_value) {
            case 0: {
                tc = UNIVERSAL;
                break;
            }
            case 64: {
                tc = APPLICATION;
                break;
            }
            case 128: {
                tc = CONTEXT_SPECIFIC;
                break;
            }
            case 192: {
                tc = PRIVATE;
            }
        }
        return tc;
    }
}

