/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.asn1.ber.DefaultMutableTupleNode;
import org.apache.asn1.ber.Tag;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleTreeDecoder;
import org.apache.asn1.ber.TypeClass;
import org.apache.asn1.ber.primitives.PrimitiveUtils;
import org.apache.asn1.ber.primitives.UniversalTag;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.binary.Hex;
import org.apache.asn1.codec.stateful.CallbackHistory;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.commons.collections.IteratorUtils;

public class TupleTreeAnalyzer
extends JFrame
implements TreeSelectionListener {
    private boolean doVmExit = false;
    private BorderLayout layout = new BorderLayout();
    private JLabel statusBar = new JLabel("Ready");
    private JSplitPane jSplitPane1 = new JSplitPane();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JPanel jPanel1 = new JPanel();
    private JTree jTree1 = new JTree();
    private JPanel jPanel2 = new JPanel();
    private JPanel jPanel5 = new JPanel();
    private JPanel jPanel3 = new JPanel();
    private JPanel jPanel4 = new JPanel();
    private JLabel jLabel1 = new JLabel();
    private JLabel jLabel3 = new JLabel();
    private JLabel jLabel2 = new JLabel();
    private JScrollPane jScrollPane2 = new JScrollPane();
    private JTextArea jTextArea1 = new JTextArea();
    private JTextField jTextField1 = new JTextField();
    private JTextField jTextField3 = new JTextField();
    private JTextField jTextField2 = new JTextField();
    private DefaultMutableTupleNode root = null;

    public TupleTreeAnalyzer(DefaultMutableTupleNode root) {
        this.root = root;
        this.initGUI();
        this.pack();
    }

    public TupleTreeAnalyzer(DefaultMutableTupleNode root, boolean doVmExit) {
        this.root = root;
        this.doVmExit = doVmExit;
        this.initGUI();
        this.pack();
    }

    public TupleTreeAnalyzer(byte[] encoded) throws DecoderException {
        this(ByteBuffer.wrap(encoded));
    }

    public TupleTreeAnalyzer(ByteBuffer encoded) throws DecoderException {
        TupleTreeDecoder decoder = new TupleTreeDecoder();
        CallbackHistory history = new CallbackHistory();
        decoder.setCallback((DecoderCallback)history);
        decoder.decode(encoded.duplicate());
        this.root = (DefaultMutableTupleNode)history.getMostRecent();
        this.initGUI();
        this.pack();
    }

    public TupleTreeAnalyzer(ByteBuffer[] encoded) throws DecoderException {
        TupleTreeDecoder decoder = new TupleTreeDecoder();
        CallbackHistory history = new CallbackHistory();
        decoder.setCallback((DecoderCallback)history);
        for (int ii = 0; ii < encoded.length; ++ii) {
            decoder.decode(encoded[ii].duplicate());
        }
        this.root = (DefaultMutableTupleNode)history.getMostRecent();
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        this.getContentPane().setLayout(this.layout);
        JPanel content = new JPanel();
        content.setPreferredSize(new Dimension(300, 200));
        this.getContentPane().add((Component)content, "Center");
        this.setTitle("");
        this.getContentPane().add((Component)this.statusBar, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("File");
        menuFile.setMnemonic('F');
        JMenuItem fileExit = new JMenuItem("Exit");
        fileExit.setMnemonic('E');
        fileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (TupleTreeAnalyzer.this.doVmExit) {
                    System.exit(0);
                }
            }
        });
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic('H');
        JMenuItem helpAbout = new JMenuItem("About");
        helpAbout.setMnemonic('A');
        helpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        menuHelp.add(helpAbout);
        final JFileChooser fc = new JFileChooser();
        JMenuItem openFile = new JMenuItem("Open");
        openFile.setMnemonic('O');
        openFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showOpenDialog(TupleTreeAnalyzer.this);
                if (returnVal == 0) {
                    // empty if block
                }
            }
        });
        menuFile.add(openFile);
        JMenuItem saveFile = new JMenuItem("Save");
        saveFile.setMnemonic('S');
        saveFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int returnVal = fc.showSaveDialog(TupleTreeAnalyzer.this);
                if (returnVal == 0) {
                    // empty if block
                }
            }
        });
        menuFile.add(saveFile);
        JMenuItem print = new JMenuItem("Print");
        print.setMnemonic('P');
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TupleTreeAnalyzer.this.hexDumpTupleTree();
            }
        });
        menuFile.add(print);
        menuFile.add(fileExit);
        menuBar.add(menuFile);
        menuBar.add(menuHelp);
        this.setJMenuBar(menuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TupleTreeAnalyzer.this.exitForm(evt);
            }
        });
        this.jLabel3.setText("Type Class:");
        this.jPanel5.setLayout(new FlowLayout(0));
        this.jPanel5.add(this.jLabel3);
        this.jPanel5.add(this.jTextField3);
        this.jTextField3.setText("");
        this.jTextField3.setMinimumSize(new Dimension(184, 25));
        this.jTextField3.setPreferredSize(new Dimension(184, 25));
        this.jSplitPane1.setLastDividerLocation(50);
        this.jSplitPane1.setDividerLocation(180);
        this.jSplitPane1.add((Component)this.jScrollPane1, "left");
        this.jSplitPane1.add((Component)this.jPanel1, "right");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TupleTreeAnalyzer.this.exitForm(evt);
            }
        });
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jScrollPane1.getViewport().add(this.jTree1);
        this.jTree1.setBounds(new Rectangle(95, 95, 85, 84));
        this.jTree1.setShowsRootHandles(true);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.add((Component)this.jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 9, 0, 9), 0, 0));
        this.jPanel1.add((Component)this.jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 9, 0, 9), 0, 0));
        this.jPanel1.add((Component)this.jPanel4, new GridBagConstraints(0, 3, 1, 35, 1.0, 1.0, 10, 1, new Insets(9, 12, 9, 12), 0, 0));
        this.jPanel1.add((Component)this.jPanel5, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 9, 0, 9), 0, 0));
        this.jLabel1.setText("Tag Id:");
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jPanel2.add(this.jLabel1);
        this.jPanel2.add(this.jTextField1);
        this.jLabel2.setText("Length:");
        this.jPanel3.setLayout(new FlowLayout(0));
        this.jPanel3.add(this.jLabel2);
        this.jPanel3.add(this.jTextField2);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 1), "Value", 4, 2, new Font("Comic Sans MS", 0, 14), new Color(60, 60, 60)));
        this.jPanel4.add((Component)this.jScrollPane2, "Center");
        this.jTextArea1.setText("");
        this.jScrollPane2.getViewport().add(this.jTextArea1);
        this.jTextField1.setText("");
        this.jTextField1.setMinimumSize(new Dimension(164, 25));
        this.jTextField1.setPreferredSize(new Dimension(164, 25));
        this.jTextField1.setEditable(true);
        this.jTextField2.setText("");
        this.jTextField2.setPreferredSize(new Dimension(164, 25));
        this.jTextField2.setMinimumSize(new Dimension(164, 25));
        this.jTextField2.setEditable(true);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setHorizontalScrollBarPolicy(32);
        this.jScrollPane2.setBorder(null);
        this.jTree1.setModel(new DefaultTreeModel(new TupleTreeNodeAdapter(this.root)));
        this.jTree1.getSelectionModel().addTreeSelectionListener(this);
    }

    private void hexDumpTupleTree() {
    }

    private void exitForm(WindowEvent evt) {
        System.out.println("Closed window: " + evt.getWindow().getName());
        if (this.doVmExit) {
            System.exit(0);
        }
    }

    public void startup() {
        this.setSize(800, 640);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        frameSize.height = frameSize.height > screenSize.height ? screenSize.height : frameSize.height;
        frameSize.width = frameSize.width > screenSize.width ? screenSize.width : frameSize.width;
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
        this.setVisible(true);
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath path = e.getPath();
        TupleTreeNodeAdapter node = (TupleTreeNodeAdapter)path.getLastPathComponent();
        DefaultMutableTupleNode tn = node.getTupleNode();
        Tuple tuple = tn.getTuple();
        TypeClass type = TypeClass.getTypeClass(tuple.getRawTag() >> 24);
        this.jTextField3.setText(type.getName());
        if (tuple.getLength() == -2) {
            this.jTextField2.setText("INDEFINITE");
        } else {
            this.jTextField2.setText(Integer.toString(tuple.getLength()));
        }
        if (type.equals(TypeClass.UNIVERSAL)) {
            UniversalTag tag = UniversalTag.getUniversalTag(tuple.getRawTag());
            this.jTextField1.setText(tag.getName());
        } else {
            this.jTextField1.setText(Integer.toString(tuple.getId()));
        }
        if (tuple.isPrimitive()) {
            ByteBuffer buf = (ByteBuffer)tuple.getLastValueChunk().rewind();
            byte[] bites = new byte[buf.remaining()];
            buf.get(bites);
            this.jTextArea1.setText(new String(Hex.encodeHex((byte[])bites)));
            if (type == TypeClass.UNIVERSAL) {
                UniversalTag tag = UniversalTag.getUniversalTag(tuple.getRawTag());
                if (tag == UniversalTag.ENUMERATED || tag == UniversalTag.INTEGER) {
                    int ii = PrimitiveUtils.decodeInt(bites, 0, bites.length);
                    this.jTextArea1.setToolTipText("Numeric: " + Integer.toString(ii));
                } else if (tag == UniversalTag.BOOLEAN) {
                    boolean bool = PrimitiveUtils.berDecodeBoolean(bites[0]);
                    this.jTextArea1.setToolTipText("Boolean: " + Boolean.toString(bool));
                } else {
                    this.jTextArea1.setToolTipText("String: " + new String(bites));
                }
            } else {
                if (bites.length > 4) {
                    this.jTextArea1.setToolTipText("String: " + new String(bites));
                    return;
                }
                int ii = PrimitiveUtils.decodeInt(bites, 0, bites.length);
                boolean bool = PrimitiveUtils.berDecodeBoolean(bites[0]);
                String tip = "Numeric: " + Integer.toString(ii) + "\n";
                tip = tip + "Boolean: " + Boolean.toString(bool) + "\n";
                tip = tip + "String: " + new String(bites);
                this.jTextArea1.setToolTipText(tip);
            }
        } else {
            this.jTextArea1.setText("N/A");
            this.jTextArea1.setToolTipText(null);
        }
    }

    public static String getHexDump(ByteBuffer buf) {
        byte[] bites = new byte[buf.remaining()];
        buf.duplicate().get(bites);
        return new String(Hex.encodeHex((byte[])bites));
    }

    public static void analyze(byte[] bites) throws DecoderException {
        TupleTreeAnalyzer analyzer = new TupleTreeAnalyzer(bites);
        analyzer.startup();
    }

    public static void analyze(ByteBuffer bites) throws DecoderException {
        TupleTreeAnalyzer analyzer = new TupleTreeAnalyzer(bites);
        analyzer.startup();
    }

    public static void main(String[] args) {
        JFileChooser fc = new JFileChooser(".");
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".ber");
            }

            public String getDescription() {
                return "BER encoded data files";
            }
        });
        fc.showOpenDialog(null);
        File file = fc.getSelectedFile();
        if (file == null) {
            System.exit(0);
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int ch = -1;
            while ((ch = in.read()) != -1) {
                out.write(ch);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
        try {
            TupleTreeAnalyzer analyzer = new TupleTreeAnalyzer(out.toByteArray());
            analyzer.startup();
        }
        catch (DecoderException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    class TupleTreeNodeAdapter
    implements TreeNode {
        DefaultMutableTupleNode node;

        TupleTreeNodeAdapter(DefaultMutableTupleNode node) {
            this.node = node;
        }

        public int getChildCount() {
            return this.node.getChildCount();
        }

        public boolean getAllowsChildren() {
            return !this.node.getTuple().isPrimitive();
        }

        public boolean isLeaf() {
            return this.node.getChildCount() == 0;
        }

        public Enumeration children() {
            return IteratorUtils.asEnumeration((Iterator)this.node.getChildren());
        }

        public TreeNode getParent() {
            return new TupleTreeNodeAdapter((DefaultMutableTupleNode)this.node.getParentTupleNode());
        }

        public TreeNode getChildAt(int childIndex) {
            return new TupleTreeNodeAdapter((DefaultMutableTupleNode)this.node.getChildTupleNodeAt(childIndex));
        }

        public int getIndex(TreeNode node) {
            DefaultMutableTupleNode tn = ((TupleTreeNodeAdapter)node).getTupleNode();
            return this.node.getIndex(tn);
        }

        DefaultMutableTupleNode getTupleNode() {
            return this.node;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            Tuple tuple = this.node.getTuple();
            TypeClass type = TypeClass.getTypeClass(this.node.getTuple().getRawTag() >> 24);
            int id = Tag.getTagId(tuple.getRawTag());
            buf.append("[").append(type.getName()).append("][").append(id).append("]").append("[").append(tuple.getLength()).append("]");
            return buf.toString();
        }
    }
}

