/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.BufferOverflowException;
import org.apache.commons.lang.ArrayUtils;

public class TagOctetCollector {
    private int intValue = 0;
    private int _size = 0;

    public void put(byte octet) {
        switch (this._size) {
            case 0: {
                this.intValue = octet << 24;
                this._size = 1;
                break;
            }
            case 1: {
                this.intValue |= octet << 16 & 0xFF0000;
                this._size = 2;
                break;
            }
            case 2: {
                this.intValue |= octet << 8 & 0xFF00;
                this._size = 3;
                break;
            }
            case 3: {
                this.intValue |= octet;
                this._size = 4;
                break;
            }
            default: {
                throw new BufferOverflowException();
            }
        }
    }

    public void clear() {
        this.intValue = 0;
        this._size = 0;
    }

    public int size() {
        return this._size;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public byte[] toArray() {
        byte[] octets = new byte[this._size];
        switch (this._size) {
            case 0: {
                octets = ArrayUtils.EMPTY_BYTE_ARRAY;
                break;
            }
            case 1: {
                octets[0] = (byte)((this.intValue & 0xFF000000) >> 24);
                break;
            }
            case 2: {
                octets[0] = (byte)((this.intValue & 0xFF000000) >> 24);
                octets[1] = (byte)((this.intValue & 0xFF0000) >> 16);
                break;
            }
            case 3: {
                octets[0] = (byte)((this.intValue & 0xFF000000) >> 24);
                octets[1] = (byte)((this.intValue & 0xFF0000) >> 16);
                octets[2] = (byte)((this.intValue & 0xFF00) >> 8);
                break;
            }
            case 4: {
                octets[0] = (byte)((this.intValue & 0xFF000000) >> 24);
                octets[1] = (byte)((this.intValue & 0xFF0000) >> 16);
                octets[2] = (byte)((this.intValue & 0xFF00) >> 8);
                octets[3] = (byte)(this.intValue & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot support more than 4 octets");
            }
        }
        return octets;
    }

    public byte get(int index) {
        byte octet;
        if (index >= this._size) {
            throw new IndexOutOfBoundsException("accesing index " + index + " with a size of " + this._size);
        }
        switch (index) {
            case 0: {
                octet = (byte)((this.intValue & 0xFF000000) >> 24);
                break;
            }
            case 1: {
                octet = (byte)((this.intValue & 0xFF0000) >> 16);
                break;
            }
            case 2: {
                octet = (byte)((this.intValue & 0xFF00) >> 8);
                break;
            }
            case 3: {
                octet = (byte)(this.intValue & 0xFF);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot support more than 4 octets");
            }
        }
        return octet;
    }
}

