/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.asn1.ber.MutableTupleNode;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.ber.TupleNode;
import org.apache.asn1.ber.TupleNodeVisitor;
import org.apache.asn1.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class DefaultMutableTupleNode
implements MutableTupleNode {
    private Tuple tuple;
    private ArrayList children = new ArrayList();
    private DefaultMutableTupleNode parent;
    private List valueChunks = new ArrayList(2);

    public DefaultMutableTupleNode() {
    }

    public DefaultMutableTupleNode(Tuple tuple) {
        this.tuple = tuple;
        if (tuple.isPrimitive() && tuple.getLastValueChunk() != null) {
            this.valueChunks.add(tuple.getLastValueChunk());
        }
    }

    public DefaultMutableTupleNode(Tuple tuple, List valueChunks) {
        this.tuple = tuple;
        this.valueChunks.addAll(valueChunks);
    }

    public void insert(MutableTupleNode child, int index) {
        this.children.add(index, child);
    }

    public void addFront(DefaultMutableTupleNode child) {
        if (this.children.isEmpty()) {
            this.children.add(child);
        } else {
            this.children.add(0, child);
        }
    }

    public void addLast(DefaultMutableTupleNode child) {
        this.children.add(child);
    }

    public void remove(int index) {
        this.children.remove(index);
    }

    public void remove(MutableTupleNode node) {
        this.children.remove(node);
    }

    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    public void setParent(MutableTupleNode newParent) {
        if (this.parent != null) {
            this.parent.remove(this);
        }
        this.parent = (DefaultMutableTupleNode)newParent;
    }

    public TupleNode getParentTupleNode() {
        return this.parent;
    }

    public Iterator getChildren() {
        return Collections.unmodifiableList(this.children).iterator();
    }

    public TupleNode getChildTupleNodeAt(int index) {
        return (TupleNode)this.children.get(index);
    }

    public int getIndex(TupleNode node) {
        return this.children.indexOf(node);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int size() {
        if (this.tuple.isPrimitive()) {
            return this.tuple.size();
        }
        int size = this.tuple.size();
        if (this.tuple.isIndefinite()) {
            TupleNode child = null;
            for (int ii = 0; ii < this.children.size(); ++ii) {
                child = (TupleNode)this.children.get(ii);
                size += child.size();
            }
            if (child != null) {
                if (!child.getTuple().isIndefiniteTerminator()) {
                    size += 2;
                }
            } else {
                size += 2;
            }
        }
        return size;
    }

    public Tuple getTuple() {
        return this.tuple;
    }

    public void setTuple(Tuple t) {
        this.tuple = t;
        this.valueChunks.clear();
    }

    public void setTuple(Tuple t, List valueChunks) {
        this.tuple = t;
        this.valueChunks.clear();
        this.valueChunks.addAll(valueChunks);
    }

    public List getValueChunks() {
        return this.valueChunks;
    }

    public void addValueChunk(ByteBuffer valueChunk) {
        this.valueChunks.add(valueChunk);
    }

    public void encode(ByteBuffer dest) {
        Tuple childTuple;
        dest.put(this.tuple.toEncodedBuffer(this.valueChunks));
        if (this.tuple.isPrimitive()) {
            return;
        }
        TupleNode child = null;
        for (int ii = 0; ii < this.children.size(); ++ii) {
            child = (TupleNode)this.children.get(ii);
            child.encode(dest);
        }
        if (child != null && (childTuple = child.getTuple()).isIndefiniteTerminator()) {
            return;
        }
        if (this.tuple.isIndefinite()) {
            dest.put((byte)0);
            dest.put((byte)0);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.tuple.getId());
        buf.append(' ').append(this.tuple.typeClass);
        buf.append('[').append(this.tuple.length).append(']');
        buf.append('[').append(new String(this.tuple.getLastValueChunk().array()));
        buf.append(']');
        return buf.toString();
    }

    public String toDepthFirstString() {
        StringBuffer buf = new StringBuffer();
        this.printDepthFirst(buf, 0);
        return buf.toString();
    }

    private String getHex(int val) {
        byte[] bites = new byte[]{(byte)((val & 0xFF000000) >> 24), (byte)((val & 0xFF0000) >> 16), (byte)((val & 0xFF00) >> 8), (byte)(val & 0xFF)};
        return new String(Hex.encodeHex((byte[])bites));
    }

    public void printDepthFirst(StringBuffer buf, int level) {
        DefaultMutableTupleNode child = null;
        String levelTab = StringUtils.repeat((String)"\t", (int)level);
        if (level != 0) {
            buf.append("\n");
        }
        buf.append(levelTab).append(this.tuple.getId());
        buf.append(" [").append("0x");
        buf.append(this.getHex(this.tuple.getRawPrimitiveTag()));
        buf.append(']');
        buf.append('[').append(this.tuple.length).append(']');
        for (int ii = 0; ii < this.children.size(); ++ii) {
            child = (DefaultMutableTupleNode)this.children.get(ii);
            child.printDepthFirst(buf, level + 1);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultMutableTupleNode) {
            return DefaultMutableTupleNode.equals(this, (DefaultMutableTupleNode)obj);
        }
        return false;
    }

    public static boolean equals(DefaultMutableTupleNode n1, DefaultMutableTupleNode n2) {
        if (n1 == n2) {
            return true;
        }
        if (!n1.getTuple().equals(n2.getTuple())) {
            return false;
        }
        if (n1.getChildCount() != n2.getChildCount()) {
            return false;
        }
        DefaultMutableTupleNode n1Child = null;
        DefaultMutableTupleNode n2Child = null;
        for (int ii = 0; ii < n1.getChildCount(); ++ii) {
            n1Child = (DefaultMutableTupleNode)n1.getChildTupleNodeAt(ii);
            if (DefaultMutableTupleNode.equals(n1Child, n2Child = (DefaultMutableTupleNode)n2.getChildTupleNodeAt(ii))) continue;
            return false;
        }
        return true;
    }

    public void accept(TupleNodeVisitor visitor) {
        if (visitor.canVisit(this)) {
            if (visitor.isPrefix()) {
                ArrayList l_children = visitor.getOrder(this, this.children);
                if (visitor.canVisit(this)) {
                    visitor.visit(this);
                }
                for (int ii = 0; ii < l_children.size(); ++ii) {
                    ((TupleNode)l_children.get(ii)).accept(visitor);
                }
            } else {
                ArrayList l_children = visitor.getOrder(this, this.children);
                for (int ii = 0; ii < l_children.size(); ++ii) {
                    ((TupleNode)l_children.get(ii)).accept(visitor);
                }
                if (visitor.canVisit(this)) {
                    visitor.visit(this);
                }
            }
        }
    }
}

