/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asn1.ber;

import java.nio.ByteBuffer;
import java.util.Stack;
import org.apache.asn1.ber.BERDecoderCallback;
import org.apache.asn1.ber.BERDecoderCallbackAdapter;
import org.apache.asn1.ber.BERDecoderMonitor;
import org.apache.asn1.ber.BERDecoderState;
import org.apache.asn1.ber.Length;
import org.apache.asn1.ber.LengthDecoder;
import org.apache.asn1.ber.Tag;
import org.apache.asn1.ber.TagDecoder;
import org.apache.asn1.ber.Tuple;
import org.apache.asn1.codec.DecoderException;
import org.apache.asn1.codec.stateful.DecoderCallback;
import org.apache.asn1.codec.stateful.DecoderMonitor;
import org.apache.asn1.codec.stateful.DecoderMonitorAdapter;
import org.apache.asn1.codec.stateful.StatefulDecoder;
import org.apache.commons.lang.ArrayUtils;

public class BERDecoder
implements StatefulDecoder,
DecoderCallback {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(ArrayUtils.EMPTY_BYTE_ARRAY);
    private static final BERDecoderCallback DEFAULT_CALLBACK = new BERDecoderCallbackAdapter();
    private static final DecoderMonitor DEFAULT_MONITOR = new DecoderMonitorAdapter();
    private BERDecoderCallback cb = DEFAULT_CALLBACK;
    private DecoderMonitor monitor = DEFAULT_MONITOR;
    private final Tuple tlv = new Tuple();
    private final TagDecoder tagDecoder = new TagDecoder();
    private final LengthDecoder lengthDecoder = new LengthDecoder();
    private final Stack tlvStack = new Stack();
    private BERDecoderState state = BERDecoderState.getStartState();

    public BERDecoder() {
        this.tagDecoder.setCallback(this);
        this.lengthDecoder.setCallback(this);
    }

    public void decode(Object encoded) throws DecoderException {
        ByteBuffer buf = (ByteBuffer)encoded;
        if (buf == null && this.monitor != null) {
            String msg = "ignoring null argument to decode()";
            this.monitor.warning((StatefulDecoder)this, (Exception)new IllegalArgumentException(msg));
            return;
        }
        if (buf.remaining() == 0 && this.monitor != null) {
            String msg = "ignoring empty buffer";
            this.monitor.warning((StatefulDecoder)this, (Exception)new IllegalArgumentException(msg));
            return;
        }
        while (buf.hasRemaining()) {
            switch (this.state.getValue()) {
                case 0: {
                    this.tagDecoder.decode(buf);
                    break;
                }
                case 1: {
                    this.lengthDecoder.decode(buf);
                    break;
                }
                case 2: {
                    this.decodeValue(buf);
                }
            }
        }
    }

    public void setCallback(DecoderCallback cb) {
        this.cb = (BERDecoderCallback)cb;
    }

    public void setDecoderMonitor(DecoderMonitor monitor) {
        this.monitor = monitor;
    }

    private void decodeValue(ByteBuffer buf) {
        int needToRead = -1;
        needToRead = this.tlv.valueIndex == -1 ? this.tlv.length : this.tlv.length - this.tlv.valueIndex;
        if (buf.remaining() >= needToRead) {
            this.tlv.valueChunk = (ByteBuffer)buf.slice().limit(needToRead);
            buf.position(buf.position() + needToRead);
            this.tlv.valueIndex = this.tlv.length;
            this.tlv.index += this.tlv.length;
            this.cb.partialValueDecoded(this.tlv);
            this.fireDecodeOccurred(this.tlv);
            this.updateStack(needToRead);
            this.tlv.clear();
            this.state = BERDecoderState.TAG;
        } else {
            if (this.tlv.valueIndex == -1) {
                this.tlv.valueIndex = 0;
            }
            int remaining = buf.remaining();
            this.tlv.valueChunk = buf.slice();
            buf.position(buf.limit());
            this.tlv.valueIndex += remaining;
            this.tlv.index += remaining;
            this.cb.partialValueDecoded(this.tlv);
            this.updateStack(remaining);
        }
    }

    public void decodeOccurred(StatefulDecoder decoder, Object decoded) {
        if (decoder == this.tagDecoder) {
            Tag tag = (Tag)decoded;
            this.tlv.rawTag = tag.getRawTag();
            this.tlv.id = tag.getId();
            this.tlv.isPrimitive = tag.isPrimitive();
            this.tlv.typeClass = tag.getTypeClass();
            this.tlv.index = tag.size();
            if (!this.tlv.isIndefiniteTerminator()) {
                this.fireTagDecoded();
                this.updateStack(tag.size());
            }
            this.state = this.state.getNext(tag.isPrimitive());
        } else if (decoder == this.lengthDecoder) {
            Length length = (Length)decoded;
            this.tlv.length = length.getLength();
            if (this.tlv.length == -2) {
                this.tlv.index = -2;
                this.tlv.valueIndex = -2;
            } else {
                this.tlv.index += length.size();
            }
            if (!this.tlv.isIndefiniteTerminator()) {
                this.fireLengthDecoded();
            }
            this.updateStack(length.size());
            if (!this.tlv.isPrimitive) {
                if (this.tlv.isIndefinite() || this.tlv.length > 0) {
                    this.tlvStack.push(this.tlv.clone());
                } else {
                    this.state = BERDecoderState.VALUE;
                    this.fireDecodeOccurred(this.tlv);
                }
                this.state = BERDecoderState.TAG;
                this.tlv.clear();
            } else {
                if (this.tlv.isIndefiniteTerminator()) {
                    return;
                }
                if (this.tlv.length > 0) {
                    this.state = BERDecoderState.VALUE;
                } else {
                    this.state = BERDecoderState.VALUE;
                    this.tlv.valueChunk = EMPTY_BUFFER;
                    this.cb.partialValueDecoded(this.tlv);
                    this.fireDecodeOccurred(this.tlv);
                    this.state = BERDecoderState.TAG;
                }
            }
        } else {
            throw new IllegalArgumentException("unrecognized decoder");
        }
    }

    private void fireTagDecoded() {
        if (this.cb != null) {
            this.cb.tagDecoded(this.tlv);
        }
        if (this.monitor != null && this.monitor instanceof BERDecoderMonitor) {
            BERDecoderMonitor berMonitor = (BERDecoderMonitor)this.monitor;
            berMonitor.tagDecoded(this.tlv);
        }
    }

    private void fireLengthDecoded() {
        if (this.cb != null) {
            this.cb.lengthDecoded(this.tlv);
        }
        if (this.monitor != null && this.monitor instanceof BERDecoderMonitor) {
            BERDecoderMonitor berMonitor = (BERDecoderMonitor)this.monitor;
            berMonitor.lengthDecoded(this.tlv);
        }
    }

    private void fireDecodeOccurred(Tuple tlv) {
        if (this.cb != null) {
            this.cb.decodeOccurred(this, tlv);
        }
        if (this.monitor != null) {
            this.monitor.callbackOccured((StatefulDecoder)this, (DecoderCallback)this.cb, (Object)tlv);
        }
    }

    private void updateStack(int increment) {
        for (int ii = 0; ii < this.tlvStack.size(); ++ii) {
            Tuple t = (Tuple)this.tlvStack.get(ii);
            if (t.isIndefinite()) continue;
            t.index += increment;
            if (t.valueIndex == -1) {
                t.valueIndex = 0;
            }
            t.valueIndex += increment;
        }
        if (this.tlvStack.isEmpty()) {
            return;
        }
        do {
            Tuple top;
            if ((top = (Tuple)this.tlvStack.peek()).isIndefinite() && this.tlv.isIndefiniteTerminator()) {
                this.tlvStack.pop();
                this.state = BERDecoderState.VALUE;
                this.fireDecodeOccurred(top);
                this.state = BERDecoderState.TAG;
                break;
            }
            if (top.isIndefinite() || top.valueIndex < top.length) break;
            this.tlvStack.pop();
            this.state = BERDecoderState.VALUE;
            this.fireDecodeOccurred(top);
            this.state = BERDecoderState.TAG;
        } while (this.tlvStack.size() > 0);
    }

    BERDecoderState getState() {
        return this.state;
    }

    Tuple getCurrentTuple() {
        return (Tuple)this.tlv.clone();
    }

    Stack getTupleStack() {
        Stack<Object> stack = new Stack<Object>();
        for (int ii = 0; ii < this.tlvStack.size(); ++ii) {
            Tuple t = (Tuple)this.tlvStack.get(ii);
            stack.add(t.clone());
        }
        return stack;
    }
}

