/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.spi;

import dev.failsafe.ExecutionContext;
import dev.failsafe.Policy;
import dev.failsafe.internal.EventHandler;
import dev.failsafe.spi.AsyncExecutionInternal;
import dev.failsafe.spi.ExecutionInternal;
import dev.failsafe.spi.ExecutionResult;
import dev.failsafe.spi.FailsafeFuture;
import dev.failsafe.spi.FailurePolicy;
import dev.failsafe.spi.Scheduler;
import dev.failsafe.spi.SyncExecutionInternal;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public abstract class PolicyExecutor<R> {
    private final int policyIndex;
    private final FailurePolicy<R> failurePolicy;
    private final EventHandler<R> successHandler;
    private final EventHandler<R> failureHandler;

    protected PolicyExecutor(Policy<R> policy, int policyIndex) {
        this.policyIndex = policyIndex;
        this.failurePolicy = policy instanceof FailurePolicy ? (FailurePolicy)policy : null;
        this.successHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getSuccessListener());
        this.failureHandler = EventHandler.ofExecutionCompleted(policy.getConfig().getFailureListener());
    }

    public int getPolicyIndex() {
        return this.policyIndex;
    }

    protected ExecutionResult<R> preExecute() {
        return null;
    }

    public Function<SyncExecutionInternal<R>, ExecutionResult<R>> apply(Function<SyncExecutionInternal<R>, ExecutionResult<R>> innerFn, Scheduler scheduler) {
        return execution -> {
            ExecutionResult<R> result = this.preExecute();
            if (result != null) {
                execution.preExecute();
                return result;
            }
            return this.postExecute((ExecutionInternal<R>)execution, (ExecutionResult)innerFn.apply((SyncExecutionInternal<R>)execution));
        };
    }

    public ExecutionResult<R> postExecute(ExecutionInternal<R> execution, ExecutionResult<R> result) {
        execution.recordAttempt();
        if (this.isFailure(result)) {
            result = this.onFailure(execution, result.withFailure());
            this.handleFailure(result, execution);
        } else {
            result = result.withSuccess();
            this.onSuccess(result);
            this.handleSuccess(result, execution);
        }
        return result;
    }

    public Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> applyAsync(Function<AsyncExecutionInternal<R>, CompletableFuture<ExecutionResult<R>>> innerFn, Scheduler scheduler, FailsafeFuture<R> future) {
        return execution -> {
            ExecutionResult<R> result = this.preExecute();
            if (result != null) {
                execution.preExecute();
                return CompletableFuture.completedFuture(result);
            }
            return ((CompletableFuture)innerFn.apply((AsyncExecutionInternal<R>)execution)).thenCompose(r -> r == null ? ExecutionResult.nullFuture() : this.postExecuteAsync((AsyncExecutionInternal<R>)execution, (ExecutionResult<R>)r, scheduler, future));
        };
    }

    protected synchronized CompletableFuture<ExecutionResult<R>> postExecuteAsync(AsyncExecutionInternal<R> execution, ExecutionResult<R> result, Scheduler scheduler, FailsafeFuture<R> future) {
        CompletableFuture<ExecutionResult<R>> postFuture = null;
        if (!execution.isAsyncExecution() || !execution.isPostExecuted(this.policyIndex)) {
            execution.recordAttempt();
            if (this.isFailure(result)) {
                postFuture = this.onFailureAsync(execution, result.withFailure(), scheduler, future).whenComplete((postResult, error) -> this.handleFailure((ExecutionResult<R>)postResult, execution));
            } else {
                result = result.withSuccess();
                this.onSuccess(result);
                this.handleSuccess(result, execution);
                postFuture = CompletableFuture.completedFuture(result);
            }
            if (execution.isAsyncExecution()) {
                execution.setPostExecuted(this.policyIndex);
            }
        }
        return postFuture;
    }

    protected boolean isFailure(ExecutionResult<R> result) {
        if (result.isNonResult()) {
            return false;
        }
        if (this.failurePolicy != null) {
            return this.failurePolicy.isFailure(result.getResult(), result.getFailure());
        }
        return result.getFailure() != null;
    }

    protected void onSuccess(ExecutionResult<R> result) {
    }

    protected ExecutionResult<R> onFailure(ExecutionContext<R> context, ExecutionResult<R> result) {
        return result;
    }

    protected CompletableFuture<ExecutionResult<R>> onFailureAsync(ExecutionContext<R> context, ExecutionResult<R> result, Scheduler scheduler, FailsafeFuture<R> future) {
        try {
            return CompletableFuture.completedFuture(this.onFailure(context, result));
        }
        catch (Throwable t) {
            CompletableFuture<ExecutionResult<R>> r = new CompletableFuture<ExecutionResult<R>>();
            r.completeExceptionally(t);
            return r;
        }
    }

    private void handleSuccess(ExecutionResult<R> result, ExecutionContext<R> context) {
        if (this.successHandler != null && result.isComplete()) {
            this.successHandler.handle(result, context);
        }
    }

    private void handleFailure(ExecutionResult<R> result, ExecutionContext<R> context) {
        if (this.failureHandler != null && result.isComplete()) {
            this.failureHandler.handle(result, context);
        }
    }
}

