/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.spi;

import dev.failsafe.DelayablePolicyConfig;
import dev.failsafe.ExecutionContext;
import dev.failsafe.Policy;
import dev.failsafe.PolicyConfig;
import java.time.Duration;

public interface DelayablePolicy<R>
extends Policy<R> {
    @Override
    public DelayablePolicyConfig<R> getConfig();

    default public Duration computeDelay(ExecutionContext<R> context) {
        PolicyConfig config = this.getConfig();
        Duration computed = null;
        if (context != null && ((DelayablePolicyConfig)config).getDelayFn() != null) {
            boolean delayFailureMatched;
            R exResult = context.getLastResult();
            Object exFailure = context.getLastFailure();
            Object delayResult = ((DelayablePolicyConfig)config).getDelayResult();
            Class<Throwable> delayFailure = ((DelayablePolicyConfig)config).getDelayFailure();
            boolean delayResultMatched = delayResult == null || delayResult.equals(exResult);
            boolean bl = delayFailureMatched = delayFailure == null || exFailure != null && delayFailure.isAssignableFrom(exFailure.getClass());
            if (delayResultMatched && delayFailureMatched) {
                try {
                    computed = ((DelayablePolicyConfig)config).getDelayFn().get(context);
                }
                catch (Throwable e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        }
        return computed != null && !computed.isNegative() ? computed : null;
    }
}

