/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.internal;

import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyConfig;
import dev.failsafe.internal.RetryPolicyExecutor;
import dev.failsafe.spi.DelayablePolicy;
import dev.failsafe.spi.FailurePolicy;
import dev.failsafe.spi.PolicyExecutor;
import java.util.function.BiPredicate;

public class RetryPolicyImpl<R>
implements RetryPolicy<R>,
FailurePolicy<R>,
DelayablePolicy<R> {
    private final RetryPolicyConfig<R> config;

    public RetryPolicyImpl(RetryPolicyConfig<R> config) {
        this.config = config;
    }

    @Override
    public RetryPolicyConfig<R> getConfig() {
        return this.config;
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (BiPredicate<R, Throwable> predicate : this.config.getAbortConditions()) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    @Override
    public PolicyExecutor<R> toExecutor(int policyIndex) {
        return new RetryPolicyExecutor(this, policyIndex);
    }
}

