/*
 * Decompiled with CFR 0.152.
 */
package dev.failsafe.internal;

import dev.failsafe.CircuitBreaker;
import dev.failsafe.CircuitBreakerConfig;
import dev.failsafe.ExecutionContext;
import dev.failsafe.internal.CircuitBreakerImpl;
import dev.failsafe.internal.CircuitState;
import dev.failsafe.internal.CircuitStats;

public class ClosedState<R>
extends CircuitState<R> {
    public ClosedState(CircuitBreakerImpl<R> breaker) {
        super(breaker, CircuitStats.create(breaker, ClosedState.capacityFor(breaker), true, null));
    }

    @Override
    public boolean tryAcquirePermit() {
        return true;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void handleConfigChange() {
        this.stats = CircuitStats.create(this.breaker, ClosedState.capacityFor(this.breaker), true, this.stats);
    }

    @Override
    synchronized void checkThreshold(ExecutionContext<R> context) {
        double failureRateThreshold;
        if (this.stats.getExecutionCount() >= this.config.getFailureExecutionThreshold() && ((failureRateThreshold = (double)this.config.getFailureRateThreshold()) != 0.0 && (double)this.stats.getFailureRate() >= failureRateThreshold || failureRateThreshold == 0.0 && this.stats.getFailureCount() >= this.config.getFailureThreshold())) {
            this.breaker.open(context);
        }
    }

    private static int capacityFor(CircuitBreaker<?> breaker) {
        if (((CircuitBreakerConfig)breaker.getConfig()).getFailureExecutionThreshold() != 0) {
            return ((CircuitBreakerConfig)breaker.getConfig()).getFailureExecutionThreshold();
        }
        return ((CircuitBreakerConfig)breaker.getConfig()).getFailureThresholdingCapacity();
    }
}

